/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorRetreat<E extends EntityInsentient>
extends Behavior<E> {
    private final int tooCloseDistance;
    private final float strafeSpeed;

    public BehaviorRetreat(int var0, float var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.tooCloseDistance = var0;
        this.strafeSpeed = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return this.isTargetVisible(var1) && this.isTargetTooClose(var1);
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(this.getTarget(var1), true));
        ((EntityInsentient)var1).getMoveControl().strafe(-this.strafeSpeed, 0.0f);
        ((Entity)var1).setYRot(MathHelper.rotateIfNecessary(((Entity)var1).getYRot(), ((EntityInsentient)var1).yHeadRot, 0.0f));
    }

    private boolean isTargetVisible(E var0) {
        return ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().contains(this.getTarget(var0));
    }

    private boolean isTargetTooClose(E var0) {
        return this.getTarget(var0).closerThan((Entity)var0, this.tooCloseDistance);
    }

    private EntityLiving getTarget(E var0) {
        return ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }
}

