/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;

public class BehaviorPlay
extends Behavior<EntityCreature> {
    private static final int MAX_FLEE_XZ_DIST = 20;
    private static final int MAX_FLEE_Y_DIST = 8;
    private static final float FLEE_SPEED_MODIFIER = 0.6f;
    private static final float CHASE_SPEED_MODIFIER = 0.6f;
    private static final int MAX_CHASERS_PER_TARGET = 5;
    private static final int AVERAGE_WAIT_TIME_BETWEEN_RUNS = 10;

    public BehaviorPlay() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return var0.getRandom().nextInt(10) == 0 && this.hasFriendsNearby(var1);
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var12, long var2) {
        EntityLiving var4 = this.seeIfSomeoneIsChasingMe(var12);
        if (var4 != null) {
            this.fleeFromChaser(var0, var12, var4);
            return;
        }
        Optional<EntityLiving> var5 = this.findSomeoneBeingChased(var12);
        if (var5.isPresent()) {
            BehaviorPlay.chaseKid(var12, var5.get());
            return;
        }
        this.findSomeoneToChase(var12).ifPresent(var1 -> BehaviorPlay.chaseKid(var12, var1));
    }

    private void fleeFromChaser(WorldServer var0, EntityCreature var1, EntityLiving var2) {
        for (int var3 = 0; var3 < 10; ++var3) {
            Vec3D var4 = LandRandomPos.getPos(var1, 20, 8);
            if (var4 == null || !var0.isVillage(new BlockPosition(var4))) continue;
            var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var4, 0.6f, 0));
            return;
        }
    }

    private static void chaseKid(EntityCreature var0, EntityLiving var1) {
        BehaviorController<?> var2 = var0.getBrain();
        var2.setMemory(MemoryModuleType.INTERACTION_TARGET, var1);
        var2.setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var1, true));
        var2.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorPositionEntity(var1, false), 0.6f, 1));
    }

    private Optional<EntityLiving> findSomeoneToChase(EntityCreature var0) {
        return this.getFriendsNearby(var0).stream().findAny();
    }

    private Optional<EntityLiving> findSomeoneBeingChased(EntityCreature var02) {
        Map<EntityLiving, Integer> var1 = this.checkHowManyChasersEachFriendHas(var02);
        return var1.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).filter(var0 -> (Integer)var0.getValue() > 0 && (Integer)var0.getValue() <= 5).map(Map.Entry::getKey).findFirst();
    }

    private Map<EntityLiving, Integer> checkHowManyChasersEachFriendHas(EntityCreature var0) {
        HashMap var1 = Maps.newHashMap();
        this.getFriendsNearby(var0).stream().filter(this::isChasingSomeone).forEach(var12 -> var1.compute(this.whoAreYouChasing((EntityLiving)var12), (var0, var1) -> var1 == null ? 1 : var1 + 1));
        return var1;
    }

    private List<EntityLiving> getFriendsNearby(EntityCreature var0) {
        return var0.getBrain().getMemory(MemoryModuleType.VISIBLE_VILLAGER_BABIES).get();
    }

    private EntityLiving whoAreYouChasing(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
    }

    @Nullable
    private EntityLiving seeIfSomeoneIsChasingMe(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.VISIBLE_VILLAGER_BABIES).get().stream().filter(var1 -> this.isFriendChasingMe(var0, (EntityLiving)var1)).findAny().orElse(null);
    }

    private boolean isChasingSomeone(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).isPresent();
    }

    private boolean isFriendChasingMe(EntityLiving var0, EntityLiving var12) {
        return var12.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).filter(var1 -> var1 == var0).isPresent();
    }

    private boolean hasFriendsNearby(EntityCreature var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.VISIBLE_VILLAGER_BABIES);
    }
}

