/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class BehaviorLookTarget
extends Behavior<EntityLiving> {
    private final Predicate<EntityLiving> predicate;
    private final float maxDistSqr;
    private Optional<EntityLiving> nearestEntityMatchingTest = Optional.empty();

    public BehaviorLookTarget(Tag<EntityTypes<?>> var0, float var12) {
        this((EntityLiving var1) -> var1.getType().is(var0), var12);
    }

    public BehaviorLookTarget(EnumCreatureType var0, float var12) {
        this((EntityLiving var1) -> var0.equals(var1.getType().getCategory()), var12);
    }

    public BehaviorLookTarget(EntityTypes<?> var0, float var12) {
        this((EntityLiving var1) -> var0.equals(var1.getType()), var12);
    }

    public BehaviorLookTarget(float var02) {
        this((EntityLiving var0) -> true, var02);
    }

    public BehaviorLookTarget(Predicate<EntityLiving> var0, float var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.predicate = var0;
        this.maxDistSqr = var1 * var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityLiving var12) {
        NearestVisibleLivingEntities var2 = var12.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get();
        this.nearestEntityMatchingTest = var2.findClosest(this.predicate.and(var1 -> var1.distanceToSqr(var12) <= (double)this.maxDistSqr));
        return this.nearestEntityMatchingTest.isPresent();
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var1, long var2) {
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(this.nearestEntityMatchingTest.get(), true));
        this.nearestEntityMatchingTest = Optional.empty();
    }
}

