/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class BehaviorInteract<E extends EntityLiving, T extends EntityLiving>
extends Behavior<E> {
    private final int maxDist;
    private final float speedModifier;
    private final EntityTypes<? extends T> type;
    private final int interactionRangeSqr;
    private final Predicate<T> targetFilter;
    private final Predicate<E> selfFilter;
    private final MemoryModuleType<T> memory;

    public BehaviorInteract(EntityTypes<? extends T> var0, int var1, Predicate<E> var2, Predicate<T> var3, MemoryModuleType<T> var4, float var5, int var6) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.type = var0;
        this.speedModifier = var5;
        this.interactionRangeSqr = var1 * var1;
        this.maxDist = var6;
        this.targetFilter = var3;
        this.selfFilter = var2;
        this.memory = var4;
    }

    public static <T extends EntityLiving> BehaviorInteract<EntityLiving, T> of(EntityTypes<? extends T> var02, int var1, MemoryModuleType<T> var2, float var3, int var4) {
        return new BehaviorInteract<EntityLiving, EntityLiving>(var02, var1, var0 -> true, var0 -> true, var2, var3, var4);
    }

    public static <T extends EntityLiving> BehaviorInteract<EntityLiving, T> of(EntityTypes<? extends T> var02, int var1, Predicate<T> var2, MemoryModuleType<T> var3, float var4, int var5) {
        return new BehaviorInteract<EntityLiving, T>(var02, var1, var0 -> true, var2, var3, var4, var5);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return this.selfFilter.test(var1) && this.seesAtLeastOneValidTarget(var1);
    }

    private boolean seesAtLeastOneValidTarget(E var0) {
        NearestVisibleLivingEntities var1 = ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get();
        return var1.contains(this::isTargetValid);
    }

    private boolean isTargetValid(EntityLiving var0) {
        return this.type.equals(var0.getType()) && this.targetFilter.test(var0);
    }

    @Override
    protected void start(WorldServer var0, E var12, long var2) {
        BehaviorController<?> var4 = ((EntityLiving)var12).getBrain();
        Optional<NearestVisibleLivingEntities> var5 = var4.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        if (var5.isEmpty()) {
            return;
        }
        NearestVisibleLivingEntities var6 = var5.get();
        var6.findClosest(var1 -> this.canInteract(var12, (EntityLiving)var1)).ifPresent(var1 -> {
            var4.setMemory(this.memory, var1);
            var4.setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity((Entity)var1, true));
            var4.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorPositionEntity((Entity)var1, false), this.speedModifier, this.maxDist));
        });
    }

    private boolean canInteract(E var0, EntityLiving var1) {
        return this.type.equals(var1.getType()) && var1.distanceToSqr((Entity)var0) <= (double)this.interactionRangeSqr && this.targetFilter.test(var1);
    }
}

