/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.state.IBlockData;

public class BehaviorBonemeal
extends Behavior<EntityVillager> {
    private static final int BONEMEALING_DURATION = 80;
    private long nextWorkCycleTime;
    private long lastBonemealingSession;
    private int timeWorkedSoFar;
    private Optional<BlockPosition> cropPos = Optional.empty();

    public BehaviorBonemeal() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        if (var1.tickCount % 10 != 0 || this.lastBonemealingSession != 0L && this.lastBonemealingSession + 160L > (long)var1.tickCount) {
            return false;
        }
        if (var1.getInventory().countItem(Items.BONE_MEAL) <= 0) {
            return false;
        }
        this.cropPos = this.pickNextTarget(var0, var1);
        return this.cropPos.isPresent();
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return this.timeWorkedSoFar < 80 && this.cropPos.isPresent();
    }

    private Optional<BlockPosition> pickNextTarget(WorldServer var0, EntityVillager var1) {
        BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition();
        Optional<BlockPosition> var3 = Optional.empty();
        int var4 = 0;
        for (int var5 = -1; var5 <= 1; ++var5) {
            for (int var6 = -1; var6 <= 1; ++var6) {
                for (int var7 = -1; var7 <= 1; ++var7) {
                    var2.setWithOffset(var1.blockPosition(), var5, var6, var7);
                    if (!this.validPos(var2, var0) || var0.random.nextInt(++var4) != 0) continue;
                    var3 = Optional.of(var2.immutable());
                }
            }
        }
        return var3;
    }

    private boolean validPos(BlockPosition var0, WorldServer var1) {
        IBlockData var2 = var1.getBlockState(var0);
        Block var3 = var2.getBlock();
        return var3 instanceof BlockCrops && !((BlockCrops)var3).isMaxAge(var2);
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        this.setCurrentCropAsTarget(var1);
        var1.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.BONE_MEAL));
        this.nextWorkCycleTime = var2;
        this.timeWorkedSoFar = 0;
    }

    private void setCurrentCropAsTarget(EntityVillager var0) {
        this.cropPos.ifPresent(var1 -> {
            BehaviorTarget var2 = new BehaviorTarget((BlockPosition)var1);
            var0.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, var2);
            var0.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var2, 0.5f, 1));
        });
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        var1.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
        this.lastBonemealingSession = var1.tickCount;
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        BlockPosition var4 = this.cropPos.get();
        if (var2 < this.nextWorkCycleTime || !var4.closerThan(var1.position(), 1.0)) {
            return;
        }
        ItemStack var5 = ItemStack.EMPTY;
        InventorySubcontainer var6 = var1.getInventory();
        int var7 = var6.getContainerSize();
        for (int var8 = 0; var8 < var7; ++var8) {
            ItemStack var9 = var6.getItem(var8);
            if (!var9.is(Items.BONE_MEAL)) continue;
            var5 = var9;
            break;
        }
        if (!var5.isEmpty() && ItemBoneMeal.growCrop(var5, var0, var4)) {
            var0.levelEvent(1505, var4, 0);
            this.cropPos = this.pickNextTarget(var0, var1);
            this.setCurrentCropAsTarget(var1);
            this.nextWorkCycleTime = var2 + 40L;
        }
        ++this.timeWorkedSoFar;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityVillager)entityLiving, l2);
    }
}

