/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class BehaviorBellRing
extends Behavior<EntityLiving> {
    private static final float BELL_RING_CHANCE = 0.95f;
    public static final int RING_BELL_FROM_DISTANCE = 3;

    public BehaviorBellRing() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.MEETING_POINT, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityLiving var1) {
        return var0.random.nextFloat() > 0.95f;
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var1, long var2) {
        IBlockData var6;
        BehaviorController<?> var4 = var1.getBrain();
        BlockPosition var5 = var4.getMemory(MemoryModuleType.MEETING_POINT).get().pos();
        if (var5.closerThan(var1.blockPosition(), 3.0) && (var6 = var0.getBlockState(var5)).is(Blocks.BELL)) {
            BlockBell var7 = (BlockBell)var6.getBlock();
            var7.attemptToRing(var1, var0, var5, null);
        }
    }
}

