/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorAttackTargetForget<E extends EntityInsentient>
extends Behavior<E> {
    private static final int TIMEOUT_TO_GET_WITHIN_ATTACK_RANGE = 200;
    private final Predicate<EntityLiving> stopAttackingWhen;
    private final Consumer<E> onTargetErased;

    public BehaviorAttackTargetForget(Predicate<EntityLiving> var0, Consumer<E> var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)((Object)MemoryStatus.REGISTERED)));
        this.stopAttackingWhen = var0;
        this.onTargetErased = var1;
    }

    public BehaviorAttackTargetForget(Predicate<EntityLiving> var02) {
        this(var02, var0 -> {});
    }

    public BehaviorAttackTargetForget(Consumer<E> var02) {
        this((EntityLiving var0) -> false, var02);
    }

    public BehaviorAttackTargetForget() {
        this((EntityLiving var0) -> false, var0 -> {});
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        EntityLiving var4 = this.getAttackTarget(var1);
        if (!((EntityLiving)var1).canAttack(var4)) {
            this.clearAttackTarget(var1);
            return;
        }
        if (BehaviorAttackTargetForget.isTiredOfTryingToReachTarget(var1)) {
            this.clearAttackTarget(var1);
            return;
        }
        if (this.isCurrentTargetDeadOrRemoved(var1)) {
            this.clearAttackTarget(var1);
            return;
        }
        if (this.isCurrentTargetInDifferentLevel(var1)) {
            this.clearAttackTarget(var1);
            return;
        }
        if (this.stopAttackingWhen.test(this.getAttackTarget(var1))) {
            this.clearAttackTarget(var1);
            return;
        }
    }

    private boolean isCurrentTargetInDifferentLevel(E var0) {
        return this.getAttackTarget(var0).level != ((EntityInsentient)var0).level;
    }

    private EntityLiving getAttackTarget(E var0) {
        return ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    private static <E extends EntityLiving> boolean isTiredOfTryingToReachTarget(E var0) {
        Optional<Long> var1 = var0.getBrain().getMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        return var1.isPresent() && var0.level.getGameTime() - var1.get() > 200L;
    }

    private boolean isCurrentTargetDeadOrRemoved(E var0) {
        Optional<EntityLiving> var1 = ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        return var1.isPresent() && !var1.get().isAlive();
    }

    protected void clearAttackTarget(E var0) {
        this.onTargetErased.accept(var0);
        ((EntityLiving)var0).getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
    }
}

