/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.damagesource.DamageSourceNetherBed;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.EntityDamageSourceIndirect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3D;

public class DamageSource {
    public static final DamageSource IN_FIRE = new DamageSource("inFire").bypassArmor().setIsFire();
    public static final DamageSource LIGHTNING_BOLT = new DamageSource("lightningBolt");
    public static final DamageSource ON_FIRE = new DamageSource("onFire").bypassArmor().setIsFire();
    public static final DamageSource LAVA = new DamageSource("lava").setIsFire();
    public static final DamageSource HOT_FLOOR = new DamageSource("hotFloor").setIsFire();
    public static final DamageSource IN_WALL = new DamageSource("inWall").bypassArmor();
    public static final DamageSource CRAMMING = new DamageSource("cramming").bypassArmor();
    public static final DamageSource DROWN = new DamageSource("drown").bypassArmor();
    public static final DamageSource STARVE = new DamageSource("starve").bypassArmor().bypassMagic();
    public static final DamageSource CACTUS = new DamageSource("cactus");
    public static final DamageSource FALL = new DamageSource("fall").bypassArmor().setIsFall();
    public static final DamageSource FLY_INTO_WALL = new DamageSource("flyIntoWall").bypassArmor();
    public static final DamageSource OUT_OF_WORLD = new DamageSource("outOfWorld").bypassArmor().bypassInvul();
    public static final DamageSource GENERIC = new DamageSource("generic").bypassArmor();
    public static final DamageSource MAGIC = new DamageSource("magic").bypassArmor().setMagic();
    public static final DamageSource WITHER = new DamageSource("wither").bypassArmor();
    public static final DamageSource ANVIL = new DamageSource("anvil").damageHelmet();
    public static final DamageSource FALLING_BLOCK = new DamageSource("fallingBlock").damageHelmet();
    public static final DamageSource DRAGON_BREATH = new DamageSource("dragonBreath").bypassArmor();
    public static final DamageSource DRY_OUT = new DamageSource("dryout");
    public static final DamageSource SWEET_BERRY_BUSH = new DamageSource("sweetBerryBush");
    public static final DamageSource FREEZE = new DamageSource("freeze").bypassArmor();
    public static final DamageSource FALLING_STALACTITE = new DamageSource("fallingStalactite").damageHelmet();
    public static final DamageSource STALAGMITE = new DamageSource("stalagmite").bypassArmor().setIsFall();
    private boolean damageHelmet;
    private boolean bypassArmor;
    private boolean bypassInvul;
    private boolean bypassMagic;
    private float exhaustion = 0.1f;
    private boolean isFireSource;
    private boolean isProjectile;
    private boolean scalesWithDifficulty;
    private boolean isMagic;
    private boolean isExplosion;
    private boolean isFall;
    private boolean noAggro;
    public final String msgId;

    public static DamageSource sting(EntityLiving var0) {
        return new EntityDamageSource("sting", var0);
    }

    public static DamageSource mobAttack(EntityLiving var0) {
        return new EntityDamageSource("mob", var0);
    }

    public static DamageSource indirectMobAttack(Entity var0, @Nullable EntityLiving var1) {
        return new EntityDamageSourceIndirect("mob", var0, var1);
    }

    public static DamageSource playerAttack(EntityHuman var0) {
        return new EntityDamageSource("player", var0);
    }

    public static DamageSource arrow(EntityArrow var0, @Nullable Entity var1) {
        return new EntityDamageSourceIndirect("arrow", var0, var1).setProjectile();
    }

    public static DamageSource trident(Entity var0, @Nullable Entity var1) {
        return new EntityDamageSourceIndirect("trident", var0, var1).setProjectile();
    }

    public static DamageSource fireworks(EntityFireworks var0, @Nullable Entity var1) {
        return new EntityDamageSourceIndirect("fireworks", var0, var1).setExplosion();
    }

    public static DamageSource fireball(EntityFireballFireball var0, @Nullable Entity var1) {
        if (var1 == null) {
            return new EntityDamageSourceIndirect("onFire", var0, var0).setIsFire().setProjectile();
        }
        return new EntityDamageSourceIndirect("fireball", var0, var1).setIsFire().setProjectile();
    }

    public static DamageSource witherSkull(EntityWitherSkull var0, Entity var1) {
        return new EntityDamageSourceIndirect("witherSkull", var0, var1).setProjectile();
    }

    public static DamageSource thrown(Entity var0, @Nullable Entity var1) {
        return new EntityDamageSourceIndirect("thrown", var0, var1).setProjectile();
    }

    public static DamageSource indirectMagic(Entity var0, @Nullable Entity var1) {
        return new EntityDamageSourceIndirect("indirectMagic", var0, var1).bypassArmor().setMagic();
    }

    public static DamageSource thorns(Entity var0) {
        return new EntityDamageSource("thorns", var0).setThorns().setMagic();
    }

    public static DamageSource explosion(@Nullable Explosion var0) {
        return DamageSource.explosion(var0 != null ? var0.getSourceMob() : null);
    }

    public static DamageSource explosion(@Nullable EntityLiving var0) {
        if (var0 != null) {
            return new EntityDamageSource("explosion.player", var0).setScalesWithDifficulty().setExplosion();
        }
        return new DamageSource("explosion").setScalesWithDifficulty().setExplosion();
    }

    public static DamageSource badRespawnPointExplosion() {
        return new DamageSourceNetherBed();
    }

    public String toString() {
        return "DamageSource (" + this.msgId + ")";
    }

    public boolean isProjectile() {
        return this.isProjectile;
    }

    public DamageSource setProjectile() {
        this.isProjectile = true;
        return this;
    }

    public boolean isExplosion() {
        return this.isExplosion;
    }

    public DamageSource setExplosion() {
        this.isExplosion = true;
        return this;
    }

    public boolean isBypassArmor() {
        return this.bypassArmor;
    }

    public boolean isDamageHelmet() {
        return this.damageHelmet;
    }

    public float getFoodExhaustion() {
        return this.exhaustion;
    }

    public boolean isBypassInvul() {
        return this.bypassInvul;
    }

    public boolean isBypassMagic() {
        return this.bypassMagic;
    }

    protected DamageSource(String var0) {
        this.msgId = var0;
    }

    @Nullable
    public Entity getDirectEntity() {
        return this.getEntity();
    }

    @Nullable
    public Entity getEntity() {
        return null;
    }

    protected DamageSource bypassArmor() {
        this.bypassArmor = true;
        this.exhaustion = 0.0f;
        return this;
    }

    protected DamageSource damageHelmet() {
        this.damageHelmet = true;
        return this;
    }

    protected DamageSource bypassInvul() {
        this.bypassInvul = true;
        return this;
    }

    protected DamageSource bypassMagic() {
        this.bypassMagic = true;
        this.exhaustion = 0.0f;
        return this;
    }

    protected DamageSource setIsFire() {
        this.isFireSource = true;
        return this;
    }

    public DamageSource setNoAggro() {
        this.noAggro = true;
        return this;
    }

    public IChatBaseComponent getLocalizedDeathMessage(EntityLiving var0) {
        EntityLiving var1 = var0.getKillCredit();
        String var2 = "death.attack." + this.msgId;
        String var3 = var2 + ".player";
        if (var1 != null) {
            return new ChatMessage(var3, var0.getDisplayName(), var1.getDisplayName());
        }
        return new ChatMessage(var2, var0.getDisplayName());
    }

    public boolean isFire() {
        return this.isFireSource;
    }

    public boolean isNoAggro() {
        return this.noAggro;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public DamageSource setScalesWithDifficulty() {
        this.scalesWithDifficulty = true;
        return this;
    }

    public boolean scalesWithDifficulty() {
        return this.scalesWithDifficulty;
    }

    public boolean isMagic() {
        return this.isMagic;
    }

    public DamageSource setMagic() {
        this.isMagic = true;
        return this;
    }

    public boolean isFall() {
        return this.isFall;
    }

    public DamageSource setIsFall() {
        this.isFall = true;
        return this;
    }

    public boolean isCreativePlayer() {
        Entity var0 = this.getEntity();
        return var0 instanceof EntityHuman && ((EntityHuman)var0).getAbilities().instabuild;
    }

    @Nullable
    public Vec3D getSourcePosition() {
        return null;
    }
}

