/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import com.mojang.serialization.Codec;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Weight {
    public static final Codec<Weight> CODEC = Codec.INT.xmap(Weight::of, Weight::asInt);
    private static final Weight ONE = new Weight(1);
    private static final Logger LOGGER = LogManager.getLogger();
    private final int value;

    private Weight(int var0) {
        this.value = var0;
    }

    public static Weight of(int var0) {
        if (var0 == 1) {
            return ONE;
        }
        Weight.validateWeight(var0);
        return new Weight(var0);
    }

    public int asInt() {
        return this.value;
    }

    private static void validateWeight(int var0) {
        if (var0 < 0) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException("Weight should be >= 0"));
        }
        if (var0 == 0 && SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.warn("Found 0 weight, make sure this is intentional!");
        }
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof Weight && this.value == ((Weight)var0).value;
    }
}

