/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.profiling.jfr.parse.JfrStatsParser;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.util.Supplier;

public class SummaryReporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Runnable onDeregistration;

    protected SummaryReporter(Runnable var0) {
        this.onDeregistration = var0;
    }

    public void recordingStopped(@Nullable Path var0) {
        JfrStatsResult var1;
        if (var0 == null) {
            return;
        }
        this.onDeregistration.run();
        SummaryReporter.infoWithFallback((Supplier<String>)((Supplier)() -> "Dumped flight recorder profiling to " + var0));
        try {
            var1 = JfrStatsParser.parse(var0);
        }
        catch (Throwable var2) {
            SummaryReporter.warnWithFallback((Supplier<String>)((Supplier)() -> "Failed to parse JFR recording"), var2);
            return;
        }
        try {
            SummaryReporter.infoWithFallback((Supplier<String>)((Supplier)var1::asJson));
            Path var2 = var0.resolveSibling("jfr-report-" + StringUtils.substringBefore((String)var0.getFileName().toString(), (String)".jfr") + ".json");
            Files.writeString(var2, (CharSequence)var1.asJson(), StandardOpenOption.CREATE);
            SummaryReporter.infoWithFallback((Supplier<String>)((Supplier)() -> "Dumped recording summary to " + var2));
        }
        catch (Throwable var2) {
            SummaryReporter.warnWithFallback((Supplier<String>)((Supplier)() -> "Failed to output JFR report"), var2);
        }
    }

    private static void infoWithFallback(Supplier<String> var0) {
        if (SummaryReporter.log4jIsActive()) {
            LOGGER.info(var0);
        } else {
            DispenserRegistry.realStdoutPrintln((String)var0.get());
        }
    }

    private static void warnWithFallback(Supplier<String> var0, Throwable var1) {
        if (SummaryReporter.log4jIsActive()) {
            LOGGER.warn(var0, var1);
        } else {
            DispenserRegistry.realStdoutPrintln((String)var0.get());
            var1.printStackTrace(DispenserRegistry.STDOUT);
        }
    }

    private static boolean log4jIsActive() {
        LoggerContext var0 = LogManager.getContext();
        if (var0 instanceof LifeCycle) {
            LifeCycle var1 = (LifeCycle)var0;
            return !var1.isStopped();
        }
        return true;
    }
}

