/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.io.IOException;
import java.io.InputStream;

public class FastBufferedInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final InputStream in;
    private final byte[] buffer;
    private int limit;
    private int position;

    public FastBufferedInputStream(InputStream var0) {
        this(var0, 8192);
    }

    public FastBufferedInputStream(InputStream var0, int var1) {
        this.in = var0;
        this.buffer = new byte[var1];
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.limit) {
            this.fill();
            if (this.position >= this.limit) {
                return -1;
            }
        }
        return Byte.toUnsignedInt(this.buffer[this.position++]);
    }

    @Override
    public int read(byte[] var0, int var1, int var2) throws IOException {
        int var3 = this.bytesInBuffer();
        if (var3 <= 0) {
            if (var2 >= this.buffer.length) {
                return this.in.read(var0, var1, var2);
            }
            this.fill();
            var3 = this.bytesInBuffer();
            if (var3 <= 0) {
                return -1;
            }
        }
        if (var2 > var3) {
            var2 = var3;
        }
        System.arraycopy(this.buffer, this.position, var0, var1, var2);
        this.position += var2;
        return var2;
    }

    @Override
    public long skip(long var0) throws IOException {
        if (var0 <= 0L) {
            return 0L;
        }
        long var2 = this.bytesInBuffer();
        if (var2 <= 0L) {
            return this.in.skip(var0);
        }
        if (var0 > var2) {
            var0 = var2;
        }
        this.position = (int)((long)this.position + var0);
        return var0;
    }

    @Override
    public int available() throws IOException {
        return this.bytesInBuffer() + this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private int bytesInBuffer() {
        return this.limit - this.position;
    }

    private void fill() throws IOException {
        this.limit = 0;
        this.position = 0;
        int var0 = this.in.read(this.buffer, 0, this.buffer.length);
        if (var0 > 0) {
            this.limit = var0;
        }
    }
}

