/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import org.apache.commons.lang3.mutable.MutableObject;

public class ExtraCodecs {
    public static final Codec<Integer> NON_NEGATIVE_INT = ExtraCodecs.intRangeWithMessage(0, Integer.MAX_VALUE, var0 -> "Value must be non-negative: " + var0);
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, var0 -> "Value must be positive: " + var0);
    public static final Codec<Float> POSITIVE_FLOAT = ExtraCodecs.floatRangeMinExclusiveWithMessage(0.0f, Float.MAX_VALUE, var0 -> "Value must be positive: " + var0);

    public static <F, S> Codec<Either<F, S>> xor(Codec<F> var0, Codec<S> var1) {
        return new c<F, S>(var0, var1);
    }

    public static <P, I> Codec<I> intervalCodec(Codec<P> var0, String var13, String var22, BiFunction<P, P, DataResult<I>> var32, Function<I, P> var4, Function<I, P> var5) {
        Codec var6 = Codec.list(var0).comapFlatMap(var12 -> SystemUtils.fixedSize(var12, 2).flatMap(var1 -> {
            Object var2 = var1.get(0);
            Object var3 = var1.get(1);
            return (DataResult)var32.apply(var2, var3);
        }), var2 -> ImmutableList.of(var4.apply(var2), var5.apply(var2)));
        Codec var7 = RecordCodecBuilder.create(var3 -> var3.group((App)var0.fieldOf(var13).forGetter(Pair::getFirst), (App)var0.fieldOf(var22).forGetter(Pair::getSecond)).apply((Applicative)var3, Pair::of)).comapFlatMap(var1 -> (DataResult)var32.apply(var1.getFirst(), var1.getSecond()), var2 -> Pair.of(var4.apply(var2), var5.apply(var2)));
        Codec var8 = new a(var6, var7).xmap(var02 -> var02.map(var0 -> var0, var0 -> var0), Either::left);
        return Codec.either(var0, (Codec)var8).comapFlatMap(var12 -> (DataResult)var12.map(var1 -> (DataResult)var32.apply(var1, var1), DataResult::success), var2 -> {
            Object var4;
            Object var3 = var4.apply(var2);
            if (Objects.equals(var3, var4 = var5.apply(var2))) {
                return Either.left(var3);
            }
            return Either.right((Object)var2);
        });
    }

    public static <A> Codec.ResultFunction<A> orElsePartial(final A var0) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> var02, T var1, DataResult<Pair<A, T>> var2) {
                MutableObject var3 = new MutableObject();
                Optional var4 = var2.resultOrPartial(arg_0 -> ((MutableObject)var3).setValue(arg_0));
                if (var4.isPresent()) {
                    return var2;
                }
                return DataResult.error((String)("(" + (String)var3.getValue() + " -> using default)"), (Object)Pair.of((Object)var0, var1));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> var02, A var1, DataResult<T> var2) {
                return var2;
            }

            public String toString() {
                return "OrElsePartial[" + var0 + "]";
            }
        };
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> var0, IntFunction<E> var12, int var22) {
        return Codec.INT.flatXmap(var1 -> Optional.ofNullable(var12.apply((int)var1)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element id: " + var1))), var2 -> {
            int var3 = var0.applyAsInt(var2);
            return var3 == var22 ? DataResult.error((String)("Element with unknown id: " + var2)) : DataResult.success((Object)var3);
        });
    }

    public static <E> Codec<E> stringResolverCodec(Function<E, String> var0, Function<String, E> var12) {
        return Codec.STRING.flatXmap(var1 -> Optional.ofNullable(var12.apply((String)var1)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element name:" + var1))), var1 -> Optional.ofNullable((String)var0.apply(var1)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Element with unknown name: " + var1))));
    }

    public static <E> Codec<E> orCompressed(final Codec<E> var0, final Codec<E> var1) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E var02, DynamicOps<T> var12, T var2) {
                if (var12.compressMaps()) {
                    return var1.encode(var02, var12, var2);
                }
                return var0.encode(var02, var12, var2);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> var02, T var12) {
                if (var02.compressMaps()) {
                    return var1.decode(var02, var12);
                }
                return var0.decode(var02, var12);
            }

            public String toString() {
                return var0 + " orCompressed " + var1;
            }
        };
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> var0, final Function<E, Lifecycle> var1, final Function<E, Lifecycle> var2) {
        return var0.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> var0, T var12, DataResult<Pair<E, T>> var22) {
                return var22.result().map(var2 -> var22.setLifecycle((Lifecycle)var1.apply(var2.getFirst()))).orElse(var22);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> var0, E var12, DataResult<T> var22) {
                return var22.setLifecycle((Lifecycle)var2.apply(var12));
            }

            public String toString() {
                return "WithLifecycle[" + var1 + " " + var2 + "]";
            }
        });
    }

    private static <N extends Number> Function<N, DataResult<N>> checkRangeWithMessage(N var0, N var1, Function<N, String> var2) {
        return var3 -> {
            if (((Comparable)((Object)var3)).compareTo(var0) >= 0 && ((Comparable)((Object)var3)).compareTo(var1) <= 0) {
                return DataResult.success((Object)var3);
            }
            return DataResult.error((String)((String)var2.apply(var3)));
        };
    }

    private static Codec<Integer> intRangeWithMessage(int var0, int var1, Function<Integer, String> var2) {
        Function<Integer, DataResult<Integer>> var3 = ExtraCodecs.checkRangeWithMessage(var0, var1, var2);
        return Codec.INT.flatXmap(var3, var3);
    }

    private static <N extends Number> Function<N, DataResult<N>> checkRangeMinExclusiveWithMessage(N var0, N var1, Function<N, String> var2) {
        return var3 -> {
            if (((Comparable)((Object)var3)).compareTo(var0) > 0 && ((Comparable)((Object)var3)).compareTo(var1) <= 0) {
                return DataResult.success((Object)var3);
            }
            return DataResult.error((String)((String)var2.apply(var3)));
        };
    }

    private static Codec<Float> floatRangeMinExclusiveWithMessage(float var0, float var1, Function<Float, String> var2) {
        Function<Float, DataResult<Float>> var3 = ExtraCodecs.checkRangeMinExclusiveWithMessage(Float.valueOf(var0), Float.valueOf(var1), var2);
        return Codec.FLOAT.flatXmap(var3, var3);
    }

    public static <T> Function<List<T>, DataResult<List<T>>> nonEmptyListCheck() {
        return var0 -> {
            if (var0.isEmpty()) {
                return DataResult.error((String)"List must have contents");
            }
            return DataResult.success((Object)var0);
        };
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> var0) {
        return var0.flatXmap(ExtraCodecs.nonEmptyListCheck(), ExtraCodecs.nonEmptyListCheck());
    }

    public static <T> Function<List<Supplier<T>>, DataResult<List<Supplier<T>>>> nonNullSupplierListCheck() {
        return var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (int var2 = 0; var2 < var0.size(); ++var2) {
                Supplier var3 = (Supplier)var0.get(var2);
                try {
                    if (var3.get() != null) continue;
                    var1.add("Missing value [" + var2 + "] : " + var3);
                    continue;
                }
                catch (Exception var4) {
                    var1.add("Invalid value [" + var2 + "]: " + var3 + ", message: " + var4.getMessage());
                }
            }
            if (!var1.isEmpty()) {
                return DataResult.error((String)String.join((CharSequence)"; ", var1));
            }
            return DataResult.success((Object)var0, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <T> Function<Supplier<T>, DataResult<Supplier<T>>> nonNullSupplierCheck() {
        return var0 -> {
            try {
                if (var0.get() == null) {
                    return DataResult.error((String)("Missing value: " + var0));
                }
            }
            catch (Exception var1) {
                return DataResult.error((String)("Invalid value: " + var0 + ", message: " + var1.getMessage()));
            }
            return DataResult.success((Object)var0, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> lazyInitializedCodec(Supplier<Codec<A>> var0) {
        return new b<A>(var0);
    }

    static final class c<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public c(Codec<F> var0, Codec<S> var1) {
            this.first = var0;
            this.second = var1;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> var02, T var1) {
            DataResult var2 = this.first.decode(var02, var1).map(var0 -> var0.mapFirst(Either::left));
            DataResult var3 = this.second.decode(var02, var1).map(var0 -> var0.mapFirst(Either::right));
            Optional var4 = var2.result();
            Optional var5 = var3.result();
            if (var4.isPresent() && var5.isPresent()) {
                return DataResult.error((String)("Both alternatives read successfully, can not pick the correct one; first: " + var4.get() + " second: " + var5.get()), (Object)((Pair)var4.get()));
            }
            return var4.isPresent() ? var2 : var3;
        }

        public <T> DataResult<T> encode(Either<F, S> var0, DynamicOps<T> var1, T var22) {
            return (DataResult)var0.map(var2 -> this.first.encode(var2, var1, var22), var2 -> this.second.encode(var2, var1, var22));
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            c var1 = (c)var0;
            return Objects.equals(this.first, var1.first) && Objects.equals(this.second, var1.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "XorCodec[" + this.first + ", " + this.second + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Either)object, dynamicOps, object2);
        }
    }

    static final class a<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public a(Codec<F> var0, Codec<S> var1) {
            this.first = var0;
            this.second = var1;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> var02, T var12) {
            DataResult var2 = this.first.decode(var02, var12).map(var0 -> var0.mapFirst(Either::left));
            if (!var2.error().isPresent()) {
                return var2;
            }
            DataResult var3 = this.second.decode(var02, var12).map(var0 -> var0.mapFirst(Either::right));
            if (!var3.error().isPresent()) {
                return var3;
            }
            return var2.apply2((var0, var1) -> var1, var3);
        }

        public <T> DataResult<T> encode(Either<F, S> var0, DynamicOps<T> var1, T var22) {
            return (DataResult)var0.map(var2 -> this.first.encode(var2, var1, var22), var2 -> this.second.encode(var2, var1, var22));
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            a var1 = (a)var0;
            return Objects.equals(this.first, var1.first) && Objects.equals(this.second, var1.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "EitherCodec[" + this.first + ", " + this.second + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Either)object, dynamicOps, object2);
        }
    }

    record b<A>(Supplier<Codec<A>> delegate) implements Codec<A>
    {
        b(Supplier<Codec<A>> var0) {
            this.delegate = var0 = Suppliers.memoize(() -> var0.get());
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var0, T var1) {
            return this.delegate.get().decode(var0, var1);
        }

        public <T> DataResult<T> encode(A var0, DynamicOps<T> var1, T var2) {
            return this.delegate.get().encode(var0, var1, var2);
        }
    }
}

