/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C>
extends ToFloatFunction<C> {
    @VisibleForDebug
    public String parityString();

    public static <C> Codec<CubicSpline<C>> codec(Codec<ToFloatFunction<C>> var03) {
        record A<C>(float location, CubicSpline<C> value, float derivative) {
        }
        MutableObject var1 = new MutableObject();
        Codec var22 = RecordCodecBuilder.create(var12 -> var12.group((App)Codec.FLOAT.fieldOf("location").forGetter(A::location), (App)ExtraCodecs.lazyInitializedCodec(() -> ((MutableObject)var1).getValue()).fieldOf("value").forGetter(A::value), (App)Codec.FLOAT.fieldOf("derivative").forGetter(A::derivative)).apply((Applicative)var12, (var0, var1, var2) -> new A((float)var0, var1, (float)var2)));
        Codec var3 = RecordCodecBuilder.create(var2 -> var2.group((App)var03.fieldOf("coordinate").forGetter(d::coordinate), (App)ExtraCodecs.nonEmptyList(var22.listOf()).fieldOf("points").forGetter(var0 -> IntStream.range(0, var0.locations.length).mapToObj(var1 -> new A(var0.locations()[var1], var0.values().get(var1), var0.derivatives()[var1])).toList())).apply((Applicative)var2, (var0, var1) -> {
            Object var2 = new float[var1.size()];
            ImmutableList.Builder var3 = ImmutableList.builder();
            float[] var4 = new float[var1.size()];
            for (int var5 = 0; var5 < var1.size(); ++var5) {
                A var6 = (A)var1.get(var5);
                var2[var5] = var6.location();
                var3.add(var6.value());
                var4[var5] = var6.derivative();
            }
            return new d(var0, (float[])var2, var3.build(), var4);
        }));
        var1.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)var3).xmap(var02 -> (CubicSpline)var02.map(c::new, var0 -> var0), var0 -> {
            Either either;
            if (var0 instanceof c) {
                c var1 = (c)var0;
                either = Either.left((Object)Float.valueOf(var1.value()));
            } else {
                either = Either.right((Object)((d)var0));
            }
            return either;
        }));
        return (Codec)var1.getValue();
    }

    public static <C> CubicSpline<C> constant(float var0) {
        return new c(var0);
    }

    public static <C> b<C> builder(ToFloatFunction<C> var0) {
        return new b<C>(var0);
    }

    public static <C> b<C> builder(ToFloatFunction<C> var0, ToFloatFunction<Float> var1) {
        return new b<C>(var0, var1);
    }

    @VisibleForDebug
    public record c<C>(float value) implements CubicSpline<C>
    {
        @Override
        public float apply(C var0) {
            return this.value;
        }

        @Override
        public String parityString() {
            return String.format("k=%.3f", Float.valueOf(this.value));
        }
    }

    public static final class b<C> {
        private final ToFloatFunction<C> coordinate;
        private final ToFloatFunction<Float> valueTransformer;
        private final FloatList locations = new FloatArrayList();
        private final List<CubicSpline<C>> values = Lists.newArrayList();
        private final FloatList derivatives = new FloatArrayList();

        protected b(ToFloatFunction<C> var02) {
            this(var02, var0 -> var0.floatValue());
        }

        protected b(ToFloatFunction<C> var0, ToFloatFunction<Float> var1) {
            this.coordinate = var0;
            this.valueTransformer = var1;
        }

        public b<C> addPoint(float var0, float var1, float var2) {
            return this.addPoint(var0, new c(this.valueTransformer.apply(Float.valueOf(var1))), var2);
        }

        public b<C> addPoint(float var0, CubicSpline<C> var1, float var2) {
            if (!this.locations.isEmpty() && var0 <= this.locations.getFloat(this.locations.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.locations.add(var0);
            this.values.add(var1);
            this.derivatives.add(var2);
            return this;
        }

        public CubicSpline<C> build() {
            if (this.locations.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return new d<C>(this.coordinate, this.locations.toFloatArray(), ImmutableList.copyOf(this.values), this.derivatives.toFloatArray());
        }
    }

    @VisibleForDebug
    public static final class d<C>
    extends Record
    implements CubicSpline<C> {
        private final ToFloatFunction<C> coordinate;
        final float[] locations;
        private final List<CubicSpline<C>> values;
        private final float[] derivatives;

        public d(ToFloatFunction<C> var0, float[] var1, List<CubicSpline<C>> var2, float[] var3) {
            if (var1.length != var2.size() || var1.length != var3.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + var1.length + " " + var2.size() + " " + var3.length);
            }
            this.coordinate = var0;
            this.locations = var1;
            this.values = var2;
            this.derivatives = var3;
        }

        @Override
        public float apply(C var0) {
            float var12 = this.coordinate.apply(var0);
            int var2 = MathHelper.binarySearch(0, this.locations.length, var1 -> var12 < this.locations[var1]) - 1;
            int var3 = this.locations.length - 1;
            if (var2 < 0) {
                return this.values.get(0).apply(var0) + this.derivatives[0] * (var12 - this.locations[0]);
            }
            if (var2 == var3) {
                return this.values.get(var3).apply(var0) + this.derivatives[var3] * (var12 - this.locations[var3]);
            }
            float var4 = this.locations[var2];
            float var5 = this.locations[var2 + 1];
            float var6 = (var12 - var4) / (var5 - var4);
            ToFloatFunction var7 = this.values.get(var2);
            ToFloatFunction var8 = this.values.get(var2 + 1);
            float var9 = this.derivatives[var2];
            float var10 = this.derivatives[var2 + 1];
            float var11 = var7.apply(var0);
            float var122 = var8.apply(var0);
            float var13 = var9 * (var5 - var4) - (var122 - var11);
            float var14 = -var10 * (var5 - var4) + (var122 - var11);
            float var15 = MathHelper.lerp(var6, var11, var122) + var6 * (1.0f - var6) * MathHelper.lerp(var6, var13, var14);
            return var15;
        }

        @Override
        @VisibleForTesting
        public String parityString() {
            return "Spline{coordinate=" + this.coordinate + ", locations=" + this.toString(this.locations) + ", derivatives=" + this.toString(this.derivatives) + ", values=" + this.values.stream().map(CubicSpline::parityString).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String toString(float[] var02) {
            return "[" + IntStream.range(0, var02.length).mapToDouble(var1 -> var02[var1]).mapToObj(var0 -> String.format(Locale.ROOT, "%.3f", var0)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "coordinate;locations;values;derivatives", "coordinate", "locations", "values", "derivatives"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "coordinate;locations;values;derivatives", "coordinate", "locations", "values", "derivatives"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "coordinate;locations;values;derivatives", "coordinate", "locations", "values", "derivatives"}, this, var0);
        }

        public ToFloatFunction<C> coordinate() {
            return this.coordinate;
        }

        public float[] locations() {
            return this.locations;
        }

        public List<CubicSpline<C>> values() {
            return this.values;
        }

        public float[] derivatives() {
            return this.derivatives;
        }
    }
}

