/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tags.Tag;

public class TagSet<T>
implements Tag<T> {
    private final ImmutableList<T> valuesList;
    private final Set<T> values;
    @VisibleForTesting
    protected final Class<?> closestCommonSuperType;

    protected TagSet(Set<T> var0, Class<?> var1) {
        this.closestCommonSuperType = var1;
        this.values = var0;
        this.valuesList = ImmutableList.copyOf(var0);
    }

    public static <T> TagSet<T> empty() {
        return new TagSet<T>(ImmutableSet.of(), Void.class);
    }

    public static <T> TagSet<T> create(Set<T> var0) {
        return new TagSet<T>(var0, TagSet.findCommonSuperClass(var0));
    }

    @Override
    public boolean contains(T var0) {
        return this.closestCommonSuperType.isInstance(var0) && this.values.contains(var0);
    }

    @Override
    public List<T> getValues() {
        return this.valuesList;
    }

    private static <T> Class<?> findCommonSuperClass(Set<T> var0) {
        if (var0.isEmpty()) {
            return Void.class;
        }
        Class<?> var1 = null;
        for (T var3 : var0) {
            if (var1 == null) {
                var1 = var3.getClass();
                continue;
            }
            var1 = TagSet.findClosestAncestor(var1, var3.getClass());
        }
        return var1;
    }

    private static Class<?> findClosestAncestor(Class<?> var0, Class<?> var1) {
        while (!var0.isAssignableFrom(var1)) {
            var0 = var0.getSuperclass();
        }
        return var0;
    }
}

