/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagStatic;
import net.minecraft.tags.TagUtil;
import net.minecraft.tags.Tags;
import net.minecraft.tags.TagsInstance;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagRegistry
implements IReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IRegistryCustom registryAccess;
    private ITagRegistry tags = ITagRegistry.EMPTY;

    public TagRegistry(IRegistryCustom var0) {
        this.registryAccess = var0;
    }

    public ITagRegistry getTags() {
        return this.tags;
    }

    @Override
    public CompletableFuture<Void> reload(IReloadListener.a var02, IResourceManager var1, GameProfilerFiller var2, GameProfilerFiller var32, Executor var4, Executor var5) {
        ArrayList var6 = Lists.newArrayList();
        TagStatic.visitHelpers(var3 -> {
            a var4 = this.createLoader(var1, var4, (TagUtil)var3);
            if (var4 != null) {
                var6.add(var4);
            }
        });
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])var6.stream().map(var0 -> var0.pendingLoad).toArray(CompletableFuture[]::new)).thenCompose(var02::wait)).thenAcceptAsync(var12 -> {
            ITagRegistry.a var2 = new ITagRegistry.a();
            var6.forEach(var1 -> var1.addToBuilder(var2));
            ITagRegistry var3 = var2.build();
            Multimap<ResourceKey<? extends IRegistry<?>>, MinecraftKey> var4 = TagStatic.getAllMissingTags(var3);
            if (!var4.isEmpty()) {
                throw new IllegalStateException("Missing required tags: " + var4.entries().stream().map(var0 -> var0.getKey() + ":" + var0.getValue()).sorted().collect(Collectors.joining(",")));
            }
            TagsInstance.bind(var3);
            this.tags = var3;
        }, var5);
    }

    @Nullable
    private <T> a<T> createLoader(IResourceManager var0, Executor var1, TagUtil<T> var2) {
        Optional<IRegistry<T>> var3 = this.registryAccess.registry(var2.getKey());
        if (var3.isPresent()) {
            IRegistry<T> var4 = var3.get();
            TagDataPack var5 = new TagDataPack(var4::getOptional, var2.getDirectory());
            CompletableFuture<Tags> var6 = CompletableFuture.supplyAsync(() -> var5.loadAndBuild(var0), var1);
            return new a<T>(var2, var6);
        }
        LOGGER.warn("Can't find registry for {}", var2.getKey());
        return null;
    }

    static class a<T> {
        private final TagUtil<T> helper;
        final CompletableFuture<? extends Tags<T>> pendingLoad;

        a(TagUtil<T> var0, CompletableFuture<? extends Tags<T>> var1) {
            this.helper = var0;
            this.pendingLoad = var1;
        }

        public void addToBuilder(ITagRegistry.a var0) {
            var0.add(this.helper.getKey(), this.pendingLoad.join());
        }
    }
}

