/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManagerFallback
implements IResourceManager {
    static final Logger LOGGER = LogManager.getLogger();
    protected final List<IResourcePack> fallbacks = Lists.newArrayList();
    private final EnumResourcePackType type;
    private final String namespace;

    public ResourceManagerFallback(EnumResourcePackType var0, String var1) {
        this.type = var0;
        this.namespace = var1;
    }

    public void add(IResourcePack var0) {
        this.fallbacks.add(var0);
    }

    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    public IResource getResource(MinecraftKey var0) throws IOException {
        this.validateLocation(var0);
        IResourcePack var1 = null;
        MinecraftKey var2 = ResourceManagerFallback.getMetadataLocation(var0);
        for (int var3 = this.fallbacks.size() - 1; var3 >= 0; --var3) {
            IResourcePack var4 = this.fallbacks.get(var3);
            if (var1 == null && var4.hasResource(this.type, var2)) {
                var1 = var4;
            }
            if (!var4.hasResource(this.type, var0)) continue;
            InputStream var5 = null;
            if (var1 != null) {
                var5 = this.getWrappedResource(var2, var1);
            }
            return new Resource(var4.getName(), var0, this.getWrappedResource(var0, var4), var5);
        }
        throw new FileNotFoundException(var0.toString());
    }

    @Override
    public boolean hasResource(MinecraftKey var0) {
        if (!this.isValidLocation(var0)) {
            return false;
        }
        for (int var1 = this.fallbacks.size() - 1; var1 >= 0; --var1) {
            IResourcePack var2 = this.fallbacks.get(var1);
            if (!var2.hasResource(this.type, var0)) continue;
            return true;
        }
        return false;
    }

    protected InputStream getWrappedResource(MinecraftKey var0, IResourcePack var1) throws IOException {
        InputStream var2 = var1.getResource(this.type, var0);
        return LOGGER.isDebugEnabled() ? new a(var2, var0, var1.getName()) : var2;
    }

    private void validateLocation(MinecraftKey var0) throws IOException {
        if (!this.isValidLocation(var0)) {
            throw new IOException("Invalid relative path to resource: " + var0);
        }
    }

    private boolean isValidLocation(MinecraftKey var0) {
        return !var0.getPath().contains("..");
    }

    @Override
    public List<IResource> getResources(MinecraftKey var0) throws IOException {
        this.validateLocation(var0);
        ArrayList var1 = Lists.newArrayList();
        MinecraftKey var2 = ResourceManagerFallback.getMetadataLocation(var0);
        for (IResourcePack var4 : this.fallbacks) {
            if (!var4.hasResource(this.type, var0)) continue;
            InputStream var5 = var4.hasResource(this.type, var2) ? this.getWrappedResource(var2, var4) : null;
            var1.add(new Resource(var4.getName(), var0, this.getWrappedResource(var0, var4), var5));
        }
        if (var1.isEmpty()) {
            throw new FileNotFoundException(var0.toString());
        }
        return var1;
    }

    @Override
    public Collection<MinecraftKey> listResources(String var0, Predicate<String> var1) {
        ArrayList var2 = Lists.newArrayList();
        for (IResourcePack var4 : this.fallbacks) {
            var2.addAll(var4.getResources(this.type, this.namespace, var0, Integer.MAX_VALUE, var1));
        }
        Collections.sort(var2);
        return var2;
    }

    @Override
    public Stream<IResourcePack> listPacks() {
        return this.fallbacks.stream();
    }

    static MinecraftKey getMetadataLocation(MinecraftKey var0) {
        return new MinecraftKey(var0.getNamespace(), var0.getPath() + ".mcmeta");
    }

    static class a
    extends FilterInputStream {
        private final String message;
        private boolean closed;

        public a(InputStream var0, MinecraftKey var1, String var2) {
            super(var0);
            ByteArrayOutputStream var3 = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(var3));
            this.message = "Leaked resource: '" + var1 + "' loaded from pack: '" + var2 + "'\n" + var3;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn(this.message);
            }
            super.finalize();
        }
    }
}

