/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.util.ChatDeserializer;
import org.apache.commons.io.IOUtils;

public class Resource
implements IResource {
    private final String sourceName;
    private final MinecraftKey location;
    private final InputStream resourceStream;
    private final InputStream metadataStream;
    private boolean triedMetadata;
    private JsonObject metadata;

    public Resource(String var0, MinecraftKey var1, InputStream var2, @Nullable InputStream var3) {
        this.sourceName = var0;
        this.location = var1;
        this.resourceStream = var2;
        this.metadataStream = var3;
    }

    @Override
    public MinecraftKey getLocation() {
        return this.location;
    }

    @Override
    public InputStream getInputStream() {
        return this.resourceStream;
    }

    @Override
    public boolean hasMetadata() {
        return this.metadataStream != null;
    }

    @Override
    @Nullable
    public <T> T getMetadata(ResourcePackMetaParser<T> var0) {
        Object var1;
        if (!this.hasMetadata()) {
            return null;
        }
        if (this.metadata == null && !this.triedMetadata) {
            this.triedMetadata = true;
            var1 = null;
            try {
                var1 = new BufferedReader(new InputStreamReader(this.metadataStream, StandardCharsets.UTF_8));
                this.metadata = ChatDeserializer.parse((Reader)var1);
            }
            finally {
                IOUtils.closeQuietly((Reader)var1);
            }
        }
        if (this.metadata == null) {
            return null;
        }
        var1 = var0.getMetadataSectionName();
        return this.metadata.has((String)var1) ? (T)var0.fromJson(ChatDeserializer.getAsJsonObject(this.metadata, (String)var1)) : null;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof Resource)) {
            return false;
        }
        Resource var1 = (Resource)var0;
        if (this.location != null ? !this.location.equals(var1.location) : var1.location != null) {
            return false;
        }
        return !(this.sourceName != null ? !this.sourceName.equals(var1.sourceName) : var1.sourceName != null);
    }

    public int hashCode() {
        int var0 = this.sourceName != null ? this.sourceName.hashCode() : 0;
        var0 = 31 * var0 + (this.location != null ? this.location.hashCode() : 0);
        return var0;
    }

    @Override
    public void close() throws IOException {
        this.resourceStream.close();
        if (this.metadataStream != null) {
            this.metadataStream.close();
        }
    }
}

