/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.MethodProfiler;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReloadableProfiled
extends Reloadable<a> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Stopwatch total = Stopwatch.createUnstarted();

    public ReloadableProfiled(IResourceManager var0, List<IReloadListener> var12, Executor var2, Executor var32, CompletableFuture<Unit> var42) {
        super(var2, var32, var0, var12, (var1, var22, var3, var4, var52) -> {
            AtomicLong var6 = new AtomicLong();
            AtomicLong var7 = new AtomicLong();
            MethodProfiler var8 = new MethodProfiler(SystemUtils.timeSource, () -> 0, false);
            MethodProfiler var9 = new MethodProfiler(SystemUtils.timeSource, () -> 0, false);
            CompletableFuture<Void> var10 = var3.reload(var1, var22, var8, var9, var2 -> var4.execute(() -> {
                Runnable var2 = SystemUtils.getNanos();
                var2.run();
                var6.addAndGet(SystemUtils.getNanos() - var2);
            }), var2 -> var52.execute(() -> {
                Runnable var2 = SystemUtils.getNanos();
                var2.run();
                var7.addAndGet(SystemUtils.getNanos() - var2);
            }));
            return var10.thenApplyAsync(var5 -> {
                LOGGER.debug("Finished reloading " + var3.getName());
                return new a(var3.getName(), var8.getResults(), var9.getResults(), var6, var7);
            }, var32);
        }, var42);
        this.total.start();
        this.allDone.thenAcceptAsync(this::finish, var32);
    }

    private void finish(List<a> var0) {
        this.total.stop();
        int var1 = 0;
        LOGGER.info("Resource reload finished after {} ms", (Object)this.total.elapsed(TimeUnit.MILLISECONDS));
        for (a var3 : var0) {
            MethodProfilerResults var4 = var3.preparationResult;
            MethodProfilerResults var5 = var3.reloadResult;
            int var6 = (int)((double)var3.preparationNanos.get() / 1000000.0);
            int var7 = (int)((double)var3.reloadNanos.get() / 1000000.0);
            int var8 = var6 + var7;
            String var9 = var3.name;
            LOGGER.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", (Object)var9, (Object)var8, (Object)var6, (Object)var7);
            var1 += var7;
        }
        LOGGER.info("Total blocking time: {} ms", (Object)var1);
    }

    public static class a {
        final String name;
        final MethodProfilerResults preparationResult;
        final MethodProfilerResults reloadResult;
        final AtomicLong preparationNanos;
        final AtomicLong reloadNanos;

        a(String var0, MethodProfilerResults var1, MethodProfilerResults var2, AtomicLong var3, AtomicLong var4) {
            this.name = var0;
            this.preparationResult = var1;
            this.reloadResult = var2;
            this.preparationNanos = var3;
            this.reloadNanos = var4;
        }
    }
}

