/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.util.ChatDeserializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ResourcePackAbstract
implements IResourcePack {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final File file;

    public ResourcePackAbstract(File var0) {
        this.file = var0;
    }

    private static String getPathFromLocation(EnumResourcePackType var0, MinecraftKey var1) {
        return String.format("%s/%s/%s", var0.getDirectory(), var1.getNamespace(), var1.getPath());
    }

    protected static String getRelativePath(File var0, File var1) {
        return var0.toURI().relativize(var1.toURI()).getPath();
    }

    @Override
    public InputStream getResource(EnumResourcePackType var0, MinecraftKey var1) throws IOException {
        return this.getResource(ResourcePackAbstract.getPathFromLocation(var0, var1));
    }

    @Override
    public boolean hasResource(EnumResourcePackType var0, MinecraftKey var1) {
        return this.hasResource(ResourcePackAbstract.getPathFromLocation(var0, var1));
    }

    protected abstract InputStream getResource(String var1) throws IOException;

    @Override
    public InputStream getRootResource(String var0) throws IOException {
        if (var0.contains("/") || var0.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        return this.getResource(var0);
    }

    protected abstract boolean hasResource(String var1);

    protected void logWarning(String var0) {
        LOGGER.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", (Object)var0, (Object)this.file);
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(ResourcePackMetaParser<T> var0) throws IOException {
        try (InputStream var1 = this.getResource("pack.mcmeta");){
            T t2 = ResourcePackAbstract.getMetadataFromStream(var0, var1);
            return t2;
        }
    }

    @Nullable
    public static <T> T getMetadataFromStream(ResourcePackMetaParser<T> var0, InputStream var1) {
        JsonObject var2;
        try (BufferedReader var3 = new BufferedReader(new InputStreamReader(var1, StandardCharsets.UTF_8));){
            var2 = ChatDeserializer.parse(var3);
        }
        catch (Exception var32) {
            LOGGER.error("Couldn't load {} metadata", (Object)var0.getMetadataSectionName(), (Object)var32);
            return null;
        }
        if (!var2.has(var0.getMetadataSectionName())) {
            return null;
        }
        try {
            return var0.fromJson(ChatDeserializer.getAsJsonObject(var2, var0.getMetadataSectionName()));
        }
        catch (Exception var3) {
            LOGGER.error("Couldn't load {} metadata", (Object)var0.getMetadataSectionName(), (Object)var3);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }
}

