/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.thread.ThreadedMailbox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextFilter
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger WORKER_COUNT = new AtomicInteger(1);
    private static final ThreadFactory THREAD_FACTORY = var0 -> {
        Thread var1 = new Thread(var0);
        var1.setName("Chat-Filter-Worker-" + WORKER_COUNT.getAndIncrement());
        return var1;
    };
    private final URL chatEndpoint;
    final URL joinEndpoint;
    final URL leaveEndpoint;
    private final String authKey;
    private final int ruleId;
    private final String serverId;
    private final String roomId;
    final a chatIgnoreStrategy;
    final ExecutorService workerPool;

    private TextFilter(URI var0, String var1, int var2, String var3, String var4, a var5, int var6) throws MalformedURLException {
        this.authKey = var1;
        this.ruleId = var2;
        this.serverId = var3;
        this.roomId = var4;
        this.chatIgnoreStrategy = var5;
        this.chatEndpoint = var0.resolve("/v1/chat").toURL();
        this.joinEndpoint = var0.resolve("/v1/join").toURL();
        this.leaveEndpoint = var0.resolve("/v1/leave").toURL();
        this.workerPool = Executors.newFixedThreadPool(var6, THREAD_FACTORY);
    }

    @Nullable
    public static TextFilter createFromConfig(String var0) {
        if (Strings.isNullOrEmpty((String)var0)) {
            return null;
        }
        try {
            JsonObject var1 = ChatDeserializer.parse(var0);
            URI var2 = new URI(ChatDeserializer.getAsString(var1, "apiServer"));
            String var3 = ChatDeserializer.getAsString(var1, "apiKey");
            if (var3.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int var4 = ChatDeserializer.getAsInt(var1, "ruleId", 1);
            String var5 = ChatDeserializer.getAsString(var1, "serverId", "");
            String var6 = ChatDeserializer.getAsString(var1, "roomId", "Java:Chat");
            int var7 = ChatDeserializer.getAsInt(var1, "hashesToDrop", -1);
            int var8 = ChatDeserializer.getAsInt(var1, "maxConcurrentRequests", 7);
            a var9 = a.select(var7);
            return new TextFilter(var2, Base64.getEncoder().encodeToString(var3.getBytes(StandardCharsets.US_ASCII)), var4, var5, var6, var9, var8);
        }
        catch (Exception var1) {
            LOGGER.warn("Failed to parse chat filter config {}", (Object)var0, (Object)var1);
            return null;
        }
    }

    void processJoinOrLeave(GameProfile var0, URL var1, Executor var2) {
        JsonObject var3 = new JsonObject();
        var3.addProperty("server", this.serverId);
        var3.addProperty("room", this.roomId);
        var3.addProperty("user_id", var0.getId().toString());
        var3.addProperty("user_display_name", var0.getName());
        var2.execute(() -> {
            try {
                this.processRequest(var3, var1);
            }
            catch (Exception var3) {
                LOGGER.warn("Failed to send join/leave packet to {} for player {}", (Object)var1, (Object)var0, (Object)var3);
            }
        });
    }

    CompletableFuture<ITextFilter.a> requestMessageProcessing(GameProfile var0, String var1, a var2, Executor var3) {
        if (var1.isEmpty()) {
            return CompletableFuture.completedFuture(ITextFilter.a.EMPTY);
        }
        JsonObject var4 = new JsonObject();
        var4.addProperty("rule", (Number)this.ruleId);
        var4.addProperty("server", this.serverId);
        var4.addProperty("room", this.roomId);
        var4.addProperty("player", var0.getId().toString());
        var4.addProperty("player_display_name", var0.getName());
        var4.addProperty("text", var1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject var3 = this.processRequestResponse(var4, this.chatEndpoint);
                boolean var4 = ChatDeserializer.getAsBoolean(var3, "response", false);
                if (var4) {
                    return ITextFilter.a.passThrough(var1);
                }
                String var5 = ChatDeserializer.getAsString(var3, "hashed", null);
                if (var5 == null) {
                    return ITextFilter.a.fullyFiltered(var1);
                }
                int var6 = ChatDeserializer.getAsJsonArray(var3, "hashes").size();
                return var2.shouldIgnore(var5, var6) ? ITextFilter.a.fullyFiltered(var1) : new ITextFilter.a(var1, var5);
            }
            catch (Exception var3) {
                LOGGER.warn("Failed to validate message '{}'", (Object)var1, (Object)var3);
                return ITextFilter.a.fullyFiltered(var1);
            }
        }, var3);
    }

    @Override
    public void close() {
        this.workerPool.shutdownNow();
    }

    private void drainStream(InputStream var0) throws IOException {
        byte[] var1 = new byte[1024];
        while (var0.read(var1) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject processRequestResponse(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.makeRequest(var0, var1);
        try (InputStream var3 = var2.getInputStream();){
            JsonObject jsonObject;
            if (var2.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(var3))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.drainStream(var3);
                throw throwable;
            }
            this.drainStream(var3);
            return jsonObject;
        }
    }

    private void processRequest(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.makeRequest(var0, var1);
        try (InputStream var3 = var2.getInputStream();){
            this.drainStream(var3);
        }
    }

    private HttpURLConnection makeRequest(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = (HttpURLConnection)var1.openConnection();
        var2.setConnectTimeout(15000);
        var2.setReadTimeout(2000);
        var2.setUseCaches(false);
        var2.setDoOutput(true);
        var2.setDoInput(true);
        var2.setRequestMethod("POST");
        var2.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        var2.setRequestProperty("Accept", "application/json");
        var2.setRequestProperty("Authorization", "Basic " + this.authKey);
        var2.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.getCurrentVersion().getName());
        try (OutputStreamWriter var3 = new OutputStreamWriter(var2.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter var4 = new JsonWriter((Writer)var3);){
            Streams.write((JsonElement)var0, (JsonWriter)var4);
        }
        int var5 = var2.getResponseCode();
        if (var5 < 200 || var5 >= 300) {
            throw new c(var5 + " " + var2.getResponseMessage());
        }
        return var2;
    }

    public ITextFilter createContext(GameProfile var0) {
        return new b(var0);
    }

    @FunctionalInterface
    public static interface a {
        public static final a NEVER_IGNORE = (var0, var1) -> false;
        public static final a IGNORE_FULLY_FILTERED = (var0, var1) -> var0.length() == var1;

        public static a ignoreOverThreshold(int var0) {
            return (var1, var2) -> var2 >= var0;
        }

        public static a select(int var0) {
            switch (var0) {
                case -1: {
                    return NEVER_IGNORE;
                }
                case 0: {
                    return IGNORE_FULLY_FILTERED;
                }
            }
            return a.ignoreOverThreshold(var0);
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    public static class c
    extends RuntimeException {
        c(String var0) {
            super(var0);
        }
    }

    class b
    implements ITextFilter {
        private final GameProfile profile;
        private final Executor streamExecutor;

        b(GameProfile var1) {
            this.profile = var1;
            ThreadedMailbox<Runnable> var2 = ThreadedMailbox.create(TextFilter.this.workerPool, "chat stream for " + var1.getName());
            this.streamExecutor = var2::tell;
        }

        @Override
        public void join() {
            TextFilter.this.processJoinOrLeave(this.profile, TextFilter.this.joinEndpoint, this.streamExecutor);
        }

        @Override
        public void leave() {
            TextFilter.this.processJoinOrLeave(this.profile, TextFilter.this.leaveEndpoint, this.streamExecutor);
        }

        @Override
        public CompletableFuture<List<ITextFilter.a>> processMessageBundle(List<String> var02) {
            List var1 = (List)var02.stream().map(var0 -> TextFilter.this.requestMessageProcessing(this.profile, (String)var0, TextFilter.this.chatIgnoreStrategy, this.streamExecutor)).collect(ImmutableList.toImmutableList());
            return SystemUtils.sequenceFailFast(var1).exceptionally(var0 -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<ITextFilter.a> processStreamMessage(String var0) {
            return TextFilter.this.requestMessageProcessing(this.profile, var0, TextFilter.this.chatIgnoreStrategy, this.streamExecutor);
        }
    }
}

