/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInResourcePackStatus;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundPongPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerConnection
implements ServerPlayerConnection,
PacketListenerPlayIn {
    static final Logger LOGGER = LogManager.getLogger();
    private static final int LATENCY_CHECK_INTERVAL = 15000;
    public final NetworkManager connection;
    private final MinecraftServer server;
    public EntityPlayer player;
    private int tickCount;
    private long keepAliveTime;
    private boolean keepAlivePending;
    private long keepAliveChallenge;
    private int chatSpamTickCount;
    private int dropSpamTickCount;
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    @Nullable
    private Entity lastVehicle;
    private double vehicleFirstGoodX;
    private double vehicleFirstGoodY;
    private double vehicleFirstGoodZ;
    private double vehicleLastGoodX;
    private double vehicleLastGoodY;
    private double vehicleLastGoodZ;
    @Nullable
    private Vec3D awaitingPositionFromClient;
    private int awaitingTeleport;
    private int awaitingTeleportTime;
    private boolean clientIsFloating;
    private int aboveGroundTickCount;
    private boolean clientVehicleIsFloating;
    private int aboveGroundVehicleTickCount;
    private int receivedMovePacketCount;
    private int knownMovePacketCount;

    public PlayerConnection(MinecraftServer var0, NetworkManager var1, EntityPlayer var2) {
        this.server = var0;
        this.connection = var1;
        var1.setListener(this);
        this.player = var2;
        var2.connection = this;
        this.keepAliveTime = SystemUtils.getMillis();
        var2.getTextFilter().join();
    }

    public void tick() {
        this.resetPosition();
        this.player.xo = this.player.getX();
        this.player.yo = this.player.getY();
        this.player.zo = this.player.getZ();
        this.player.doTick();
        this.player.absMoveTo(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.player.getYRot(), this.player.getXRot());
        ++this.tickCount;
        this.knownMovePacketCount = this.receivedMovePacketCount;
        if (this.clientIsFloating && !this.player.isSleeping()) {
            if (++this.aboveGroundTickCount > 80) {
                LOGGER.warn("{} was kicked for floating too long!", (Object)this.player.getName().getString());
                this.disconnect(new ChatMessage("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.clientIsFloating = false;
            this.aboveGroundTickCount = 0;
        }
        this.lastVehicle = this.player.getRootVehicle();
        if (this.lastVehicle == this.player || this.lastVehicle.getControllingPassenger() != this.player) {
            this.lastVehicle = null;
            this.clientVehicleIsFloating = false;
            this.aboveGroundVehicleTickCount = 0;
        } else {
            this.vehicleFirstGoodX = this.lastVehicle.getX();
            this.vehicleFirstGoodY = this.lastVehicle.getY();
            this.vehicleFirstGoodZ = this.lastVehicle.getZ();
            this.vehicleLastGoodX = this.lastVehicle.getX();
            this.vehicleLastGoodY = this.lastVehicle.getY();
            this.vehicleLastGoodZ = this.lastVehicle.getZ();
            if (this.clientVehicleIsFloating && this.player.getRootVehicle().getControllingPassenger() == this.player) {
                if (++this.aboveGroundVehicleTickCount > 80) {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)this.player.getName().getString());
                    this.disconnect(new ChatMessage("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.clientVehicleIsFloating = false;
                this.aboveGroundVehicleTickCount = 0;
            }
        }
        this.server.getProfiler().push("keepAlive");
        long var0 = SystemUtils.getMillis();
        if (var0 - this.keepAliveTime >= 15000L) {
            if (this.keepAlivePending) {
                this.disconnect(new ChatMessage("disconnect.timeout"));
            } else {
                this.keepAlivePending = true;
                this.keepAliveTime = var0;
                this.keepAliveChallenge = var0;
                this.send(new PacketPlayOutKeepAlive(this.keepAliveChallenge));
            }
        }
        this.server.getProfiler().pop();
        if (this.chatSpamTickCount > 0) {
            --this.chatSpamTickCount;
        }
        if (this.dropSpamTickCount > 0) {
            --this.dropSpamTickCount;
        }
        if (this.player.getLastActionTime() > 0L && this.server.getPlayerIdleTimeout() > 0 && SystemUtils.getMillis() - this.player.getLastActionTime() > (long)(this.server.getPlayerIdleTimeout() * 1000 * 60)) {
            this.disconnect(new ChatMessage("multiplayer.disconnect.idling"));
        }
    }

    public void resetPosition() {
        this.firstGoodX = this.player.getX();
        this.firstGoodY = this.player.getY();
        this.firstGoodZ = this.player.getZ();
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    @Override
    public NetworkManager getConnection() {
        return this.connection;
    }

    private boolean isSingleplayerOwner() {
        return this.server.isSingleplayerOwner(this.player.getGameProfile());
    }

    public void disconnect(IChatBaseComponent var0) {
        this.connection.send(new PacketPlayOutKickDisconnect(var0), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)var1 -> this.connection.disconnect(var0)));
        this.connection.setReadOnly();
        this.server.executeBlocking(this.connection::handleDisconnection);
    }

    private <T, R> void filterTextPacket(T var0, Consumer<R> var12, BiFunction<ITextFilter, T, CompletableFuture<R>> var2) {
        MinecraftServer var3 = this.player.getLevel().getServer();
        Consumer<Object> var4 = var1 -> {
            if (this.getConnection().isConnected()) {
                var12.accept(var1);
            } else {
                LOGGER.debug("Ignoring packet due to disconnection");
            }
        };
        var2.apply(this.player.getTextFilter(), (ITextFilter)var0).thenAcceptAsync(var4, (Executor)var3);
    }

    private void filterTextPacket(String var0, Consumer<ITextFilter.a> var1) {
        this.filterTextPacket(var0, var1, ITextFilter::processStreamMessage);
    }

    private void filterTextPacket(List<String> var0, Consumer<List<ITextFilter.a>> var1) {
        this.filterTextPacket(var0, var1, ITextFilter::processMessageBundle);
    }

    @Override
    public void handlePlayerInput(PacketPlayInSteerVehicle var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.setPlayerInput(var0.getXxa(), var0.getZza(), var0.isJumping(), var0.isShiftKeyDown());
    }

    private static boolean containsInvalidValues(double var0, double var2, double var4, float var6, float var7) {
        return Double.isNaN(var0) || Double.isNaN(var2) || Double.isNaN(var4) || !Floats.isFinite((float)var7) || !Floats.isFinite((float)var6);
    }

    private static double clampHorizontal(double var0) {
        return MathHelper.clamp(var0, -3.0E7, 3.0E7);
    }

    private static double clampVertical(double var0) {
        return MathHelper.clamp(var0, -2.0E7, 2.0E7);
    }

    @Override
    public void handleMoveVehicle(PacketPlayInVehicleMove var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (PlayerConnection.containsInvalidValues(var0.getX(), var0.getY(), var0.getZ(), var0.getYRot(), var0.getXRot())) {
            this.disconnect(new ChatMessage("multiplayer.disconnect.invalid_vehicle_movement"));
            return;
        }
        Entity var1 = this.player.getRootVehicle();
        if (var1 != this.player && var1.getControllingPassenger() == this.player && var1 == this.lastVehicle) {
            WorldServer var2 = this.player.getLevel();
            double var3 = var1.getX();
            double var5 = var1.getY();
            double var7 = var1.getZ();
            double var9 = PlayerConnection.clampHorizontal(var0.getX());
            double var11 = PlayerConnection.clampVertical(var0.getY());
            double var13 = PlayerConnection.clampHorizontal(var0.getZ());
            float var15 = MathHelper.wrapDegrees(var0.getYRot());
            float var16 = MathHelper.wrapDegrees(var0.getXRot());
            double var17 = var9 - this.vehicleFirstGoodX;
            double var19 = var11 - this.vehicleFirstGoodY;
            double var21 = var13 - this.vehicleFirstGoodZ;
            double var25 = var17 * var17 + var19 * var19 + var21 * var21;
            double var23 = var1.getDeltaMovement().lengthSqr();
            if (var25 - var23 > 100.0 && !this.isSingleplayerOwner()) {
                LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)var1.getName().getString(), (Object)this.player.getName().getString(), (Object)var17, (Object)var19, (Object)var21);
                this.connection.send(new PacketPlayOutVehicleMove(var1));
                return;
            }
            boolean var27 = var2.noCollision(var1, var1.getBoundingBox().deflate(0.0625));
            var17 = var9 - this.vehicleLastGoodX;
            var19 = var11 - this.vehicleLastGoodY - 1.0E-6;
            var21 = var13 - this.vehicleLastGoodZ;
            var1.move(EnumMoveType.PLAYER, new Vec3D(var17, var19, var21));
            double var28 = var19;
            var17 = var9 - var1.getX();
            var19 = var11 - var1.getY();
            if (var19 > -0.5 || var19 < 0.5) {
                var19 = 0.0;
            }
            var21 = var13 - var1.getZ();
            var25 = var17 * var17 + var19 * var19 + var21 * var21;
            boolean var30 = false;
            if (var25 > 0.0625) {
                var30 = true;
                LOGGER.warn("{} (vehicle of {}) moved wrongly! {}", (Object)var1.getName().getString(), (Object)this.player.getName().getString(), (Object)Math.sqrt(var25));
            }
            var1.absMoveTo(var9, var11, var13, var15, var16);
            boolean var31 = var2.noCollision(var1, var1.getBoundingBox().deflate(0.0625));
            if (var27 && (var30 || !var31)) {
                var1.absMoveTo(var3, var5, var7, var15, var16);
                this.connection.send(new PacketPlayOutVehicleMove(var1));
                return;
            }
            this.player.getLevel().getChunkSource().move(this.player);
            this.player.checkMovementStatistics(this.player.getX() - var3, this.player.getY() - var5, this.player.getZ() - var7);
            this.clientVehicleIsFloating = var28 >= -0.03125 && !this.server.isFlightAllowed() && this.noBlocksAround(var1);
            this.vehicleLastGoodX = var1.getX();
            this.vehicleLastGoodY = var1.getY();
            this.vehicleLastGoodZ = var1.getZ();
        }
    }

    private boolean noBlocksAround(Entity var0) {
        return var0.level.getBlockStates(var0.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0)).allMatch(BlockBase.BlockData::isAir);
    }

    @Override
    public void handleAcceptTeleportPacket(PacketPlayInTeleportAccept var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (var0.getId() == this.awaitingTeleport) {
            this.player.absMoveTo(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            this.lastGoodX = this.awaitingPositionFromClient.x;
            this.lastGoodY = this.awaitingPositionFromClient.y;
            this.lastGoodZ = this.awaitingPositionFromClient.z;
            if (this.player.isChangingDimension()) {
                this.player.hasChangedDimension();
            }
            this.awaitingPositionFromClient = null;
        }
    }

    @Override
    public void handleRecipeBookSeenRecipePacket(PacketPlayInRecipeDisplayed var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.server.getRecipeManager().byKey(var0.getRecipe()).ifPresent(this.player.getRecipeBook()::removeHighlight);
    }

    @Override
    public void handleRecipeBookChangeSettingsPacket(PacketPlayInRecipeSettings var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.getRecipeBook().setBookSetting(var0.getBookType(), var0.isOpen(), var0.isFiltering());
    }

    @Override
    public void handleSeenAdvancements(PacketPlayInAdvancements var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (var0.getAction() == PacketPlayInAdvancements.Status.OPENED_TAB) {
            MinecraftKey var1 = var0.getTab();
            Advancement var2 = this.server.getAdvancements().getAdvancement(var1);
            if (var2 != null) {
                this.player.getAdvancements().setSelectedTab(var2);
            }
        }
    }

    @Override
    public void handleCustomCommandSuggestions(PacketPlayInTabComplete var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        StringReader var12 = new StringReader(var0.getCommand());
        if (var12.canRead() && var12.peek() == '/') {
            var12.skip();
        }
        ParseResults var2 = this.server.getCommands().getDispatcher().parse(var12, (Object)this.player.createCommandSourceStack());
        this.server.getCommands().getDispatcher().getCompletionSuggestions(var2).thenAccept(var1 -> this.connection.send(new PacketPlayOutTabComplete(var0.getId(), (Suggestions)var1)));
    }

    @Override
    public void handleSetCommandBlock(PacketPlayInSetCommandBlock var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendMessage(new ChatMessage("advMode.notEnabled"), SystemUtils.NIL_UUID);
            return;
        }
        if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendMessage(new ChatMessage("advMode.notAllowed"), SystemUtils.NIL_UUID);
            return;
        }
        CommandBlockListenerAbstract var1 = null;
        TileEntityCommand var2 = null;
        BlockPosition var3 = var0.getPos();
        TileEntity var4 = this.player.level.getBlockEntity(var3);
        if (var4 instanceof TileEntityCommand) {
            var2 = (TileEntityCommand)var4;
            var1 = var2.getCommandBlock();
        }
        String var5 = var0.getCommand();
        boolean var6 = var0.isTrackOutput();
        if (var1 != null) {
            TileEntityCommand.Type var7 = var2.getMode();
            IBlockData var8 = this.player.level.getBlockState(var3);
            EnumDirection var9 = var8.getValue(BlockCommand.FACING);
            IBlockData var11 = (IBlockData)((IBlockData)(switch (var0.getMode()) {
                case TileEntityCommand.Type.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                case TileEntityCommand.Type.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                default -> Blocks.COMMAND_BLOCK.defaultBlockState();
            }).setValue(BlockCommand.FACING, var9)).setValue(BlockCommand.CONDITIONAL, var0.isConditional());
            if (var11 != var8) {
                this.player.level.setBlock(var3, var11, 2);
                var4.setBlockState(var11);
                this.player.level.getChunkAt(var3).setBlockEntity(var4);
            }
            var1.setCommand(var5);
            var1.setTrackOutput(var6);
            if (!var6) {
                var1.setLastOutput(null);
            }
            var2.setAutomatic(var0.isAutomatic());
            if (var7 != var0.getMode()) {
                var2.onModeSwitch();
            }
            var1.onUpdated();
            if (!UtilColor.isNullOrEmpty(var5)) {
                this.player.sendMessage(new ChatMessage("advMode.setCommand.success", var5), SystemUtils.NIL_UUID);
            }
        }
    }

    @Override
    public void handleSetCommandMinecart(PacketPlayInSetCommandMinecart var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendMessage(new ChatMessage("advMode.notEnabled"), SystemUtils.NIL_UUID);
            return;
        }
        if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendMessage(new ChatMessage("advMode.notAllowed"), SystemUtils.NIL_UUID);
            return;
        }
        CommandBlockListenerAbstract var1 = var0.getCommandBlock(this.player.level);
        if (var1 != null) {
            var1.setCommand(var0.getCommand());
            var1.setTrackOutput(var0.isTrackOutput());
            if (!var0.isTrackOutput()) {
                var1.setLastOutput(null);
            }
            var1.onUpdated();
            this.player.sendMessage(new ChatMessage("advMode.setCommand.success", var0.getCommand()), SystemUtils.NIL_UUID);
        }
    }

    @Override
    public void handlePickItem(PacketPlayInPickItem var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.getInventory().pickSlot(var0.getSlot());
        this.player.connection.send(new PacketPlayOutSetSlot(-2, 0, this.player.getInventory().selected, this.player.getInventory().getItem(this.player.getInventory().selected)));
        this.player.connection.send(new PacketPlayOutSetSlot(-2, 0, var0.getSlot(), this.player.getInventory().getItem(var0.getSlot())));
        this.player.connection.send(new PacketPlayOutHeldItemSlot(this.player.getInventory().selected));
    }

    @Override
    public void handleRenameItem(PacketPlayInItemName var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (this.player.containerMenu instanceof ContainerAnvil) {
            ContainerAnvil var1 = (ContainerAnvil)this.player.containerMenu;
            String var2 = SharedConstants.filterText(var0.getName());
            if (var2.length() <= 50) {
                var1.setItemName(var2);
            }
        }
    }

    @Override
    public void handleSetBeaconPacket(PacketPlayInBeacon var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (this.player.containerMenu instanceof ContainerBeacon) {
            ((ContainerBeacon)this.player.containerMenu).updateEffects(var0.getPrimary(), var0.getSecondary());
        }
    }

    @Override
    public void handleSetStructureBlock(PacketPlayInStruct var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        IBlockData var2 = this.player.level.getBlockState(var1);
        TileEntity var3 = this.player.level.getBlockEntity(var1);
        if (var3 instanceof TileEntityStructure) {
            TileEntityStructure var4 = (TileEntityStructure)var3;
            var4.setMode(var0.getMode());
            var4.setStructureName(var0.getName());
            var4.setStructurePos(var0.getOffset());
            var4.setStructureSize(var0.getSize());
            var4.setMirror(var0.getMirror());
            var4.setRotation(var0.getRotation());
            var4.setMetaData(var0.getData());
            var4.setIgnoreEntities(var0.isIgnoreEntities());
            var4.setShowAir(var0.isShowAir());
            var4.setShowBoundingBox(var0.isShowBoundingBox());
            var4.setIntegrity(var0.getIntegrity());
            var4.setSeed(var0.getSeed());
            if (var4.hasStructureName()) {
                String var5 = var4.getStructureName();
                if (var0.getUpdateType() == TileEntityStructure.UpdateType.SAVE_AREA) {
                    if (var4.saveStructure()) {
                        this.player.displayClientMessage(new ChatMessage("structure_block.save_success", var5), false);
                    } else {
                        this.player.displayClientMessage(new ChatMessage("structure_block.save_failure", var5), false);
                    }
                } else if (var0.getUpdateType() == TileEntityStructure.UpdateType.LOAD_AREA) {
                    if (!var4.isStructureLoadable()) {
                        this.player.displayClientMessage(new ChatMessage("structure_block.load_not_found", var5), false);
                    } else if (var4.loadStructure(this.player.getLevel())) {
                        this.player.displayClientMessage(new ChatMessage("structure_block.load_success", var5), false);
                    } else {
                        this.player.displayClientMessage(new ChatMessage("structure_block.load_prepare", var5), false);
                    }
                } else if (var0.getUpdateType() == TileEntityStructure.UpdateType.SCAN_AREA) {
                    if (var4.detectSize()) {
                        this.player.displayClientMessage(new ChatMessage("structure_block.size_success", var5), false);
                    } else {
                        this.player.displayClientMessage(new ChatMessage("structure_block.size_failure"), false);
                    }
                }
            } else {
                this.player.displayClientMessage(new ChatMessage("structure_block.invalid_structure_name", var0.getName()), false);
            }
            var4.setChanged();
            this.player.level.sendBlockUpdated(var1, var2, var2, 3);
        }
    }

    @Override
    public void handleSetJigsawBlock(PacketPlayInSetJigsaw var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        IBlockData var2 = this.player.level.getBlockState(var1);
        TileEntity var3 = this.player.level.getBlockEntity(var1);
        if (var3 instanceof TileEntityJigsaw) {
            TileEntityJigsaw var4 = (TileEntityJigsaw)var3;
            var4.setName(var0.getName());
            var4.setTarget(var0.getTarget());
            var4.setPool(var0.getPool());
            var4.setFinalState(var0.getFinalState());
            var4.setJoint(var0.getJoint());
            var4.setChanged();
            this.player.level.sendBlockUpdated(var1, var2, var2, 3);
        }
    }

    @Override
    public void handleJigsawGenerate(PacketPlayInJigsawGenerate var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        TileEntity var2 = this.player.level.getBlockEntity(var1);
        if (var2 instanceof TileEntityJigsaw) {
            TileEntityJigsaw var3 = (TileEntityJigsaw)var2;
            var3.generate(this.player.getLevel(), var0.levels(), var0.keepJigsaws());
        }
    }

    @Override
    public void handleSelectTrade(PacketPlayInTrSel var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        int var1 = var0.getItem();
        Container var2 = this.player.containerMenu;
        if (var2 instanceof ContainerMerchant) {
            ContainerMerchant var3 = (ContainerMerchant)var2;
            var3.setSelectionHint(var1);
            var3.tryMoveItems(var1);
        }
    }

    @Override
    public void handleEditBook(PacketPlayInBEdit var0) {
        int var12 = var0.getSlot();
        if (!PlayerInventory.isHotbarSlot(var12) && var12 != 40) {
            return;
        }
        ArrayList var2 = Lists.newArrayList();
        Optional<String> var3 = var0.getTitle();
        var3.ifPresent(var2::add);
        var0.getPages().stream().limit(100L).forEach(var2::add);
        this.filterTextPacket(var2, var3.isPresent() ? var1 -> this.signBook((ITextFilter.a)var1.get(0), var1.subList(1, var1.size()), var12) : var1 -> this.updateBookContents((List<ITextFilter.a>)var1, var12));
    }

    private void updateBookContents(List<ITextFilter.a> var0, int var1) {
        ItemStack var2 = this.player.getInventory().getItem(var1);
        if (!var2.is(Items.WRITABLE_BOOK)) {
            return;
        }
        this.updateBookPages(var0, UnaryOperator.identity(), var2);
    }

    private void signBook(ITextFilter.a var02, List<ITextFilter.a> var1, int var2) {
        ItemStack var3 = this.player.getInventory().getItem(var2);
        if (!var3.is(Items.WRITABLE_BOOK)) {
            return;
        }
        ItemStack var4 = new ItemStack(Items.WRITTEN_BOOK);
        NBTTagCompound var5 = var3.getTag();
        if (var5 != null) {
            var4.setTag(var5.copy());
        }
        var4.addTagElement("author", NBTTagString.valueOf(this.player.getName().getString()));
        if (this.player.isTextFilteringEnabled()) {
            var4.addTagElement("title", NBTTagString.valueOf(var02.getFiltered()));
        } else {
            var4.addTagElement("filtered_title", NBTTagString.valueOf(var02.getFiltered()));
            var4.addTagElement("title", NBTTagString.valueOf(var02.getRaw()));
        }
        this.updateBookPages(var1, var0 -> IChatBaseComponent.ChatSerializer.toJson(new ChatComponentText((String)var0)), var4);
        this.player.getInventory().setItem(var2, var4);
    }

    private void updateBookPages(List<ITextFilter.a> var0, UnaryOperator<String> var12, ItemStack var2) {
        NBTTagList var3 = new NBTTagList();
        if (this.player.isTextFilteringEnabled()) {
            var0.stream().map(var1 -> NBTTagString.valueOf((String)var12.apply(var1.getFiltered()))).forEach(var3::add);
        } else {
            NBTTagCompound var4 = new NBTTagCompound();
            int var6 = var0.size();
            for (int var5 = 0; var5 < var6; ++var5) {
                ITextFilter.a var7 = var0.get(var5);
                String var8 = var7.getRaw();
                var3.add(NBTTagString.valueOf((String)var12.apply(var8)));
                String var9 = var7.getFiltered();
                if (var8.equals(var9)) continue;
                var4.putString(String.valueOf(var5), (String)var12.apply(var9));
            }
            if (!var4.isEmpty()) {
                var2.addTagElement("filtered_pages", var4);
            }
        }
        var2.addTagElement("pages", var3);
    }

    @Override
    public void handleEntityTagQuery(PacketPlayInEntityNBTQuery var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.hasPermissions(2)) {
            return;
        }
        Entity var1 = this.player.getLevel().getEntity(var0.getEntityId());
        if (var1 != null) {
            NBTTagCompound var2 = var1.saveWithoutId(new NBTTagCompound());
            this.player.connection.send(new PacketPlayOutNBTQuery(var0.getTransactionId(), var2));
        }
    }

    @Override
    public void handleBlockEntityTagQuery(PacketPlayInTileNBTQuery var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.hasPermissions(2)) {
            return;
        }
        TileEntity var1 = this.player.getLevel().getBlockEntity(var0.getPos());
        NBTTagCompound var2 = var1 != null ? var1.saveWithoutMetadata() : null;
        this.player.connection.send(new PacketPlayOutNBTQuery(var0.getTransactionId(), var2));
    }

    @Override
    public void handleMovePlayer(PacketPlayInFlying var0) {
        boolean var30;
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (PlayerConnection.containsInvalidValues(var0.getX(0.0), var0.getY(0.0), var0.getZ(0.0), var0.getYRot(0.0f), var0.getXRot(0.0f))) {
            this.disconnect(new ChatMessage("multiplayer.disconnect.invalid_player_movement"));
            return;
        }
        WorldServer var1 = this.player.getLevel();
        if (this.player.wonGame) {
            return;
        }
        if (this.tickCount == 0) {
            this.resetPosition();
        }
        if (this.awaitingPositionFromClient != null) {
            if (this.tickCount - this.awaitingTeleportTime > 20) {
                this.awaitingTeleportTime = this.tickCount;
                this.teleport(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            }
            return;
        }
        this.awaitingTeleportTime = this.tickCount;
        double var2 = PlayerConnection.clampHorizontal(var0.getX(this.player.getX()));
        double var4 = PlayerConnection.clampVertical(var0.getY(this.player.getY()));
        double var6 = PlayerConnection.clampHorizontal(var0.getZ(this.player.getZ()));
        float var8 = MathHelper.wrapDegrees(var0.getYRot(this.player.getYRot()));
        float var9 = MathHelper.wrapDegrees(var0.getXRot(this.player.getXRot()));
        if (this.player.isPassenger()) {
            this.player.absMoveTo(this.player.getX(), this.player.getY(), this.player.getZ(), var8, var9);
            this.player.getLevel().getChunkSource().move(this.player);
            return;
        }
        double var10 = this.player.getX();
        double var12 = this.player.getY();
        double var14 = this.player.getZ();
        double var16 = this.player.getY();
        double var18 = var2 - this.firstGoodX;
        double var20 = var4 - this.firstGoodY;
        double var22 = var6 - this.firstGoodZ;
        double var24 = this.player.getDeltaMovement().lengthSqr();
        double var26 = var18 * var18 + var20 * var20 + var22 * var22;
        if (this.player.isSleeping()) {
            if (var26 > 1.0) {
                this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), var8, var9);
            }
            return;
        }
        ++this.receivedMovePacketCount;
        int var28 = this.receivedMovePacketCount - this.knownMovePacketCount;
        if (var28 > 5) {
            LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.player.getName().getString(), (Object)var28);
            var28 = 1;
        }
        if (!(this.player.isChangingDimension() || this.player.getLevel().getGameRules().getBoolean(GameRules.RULE_DISABLE_ELYTRA_MOVEMENT_CHECK) && this.player.isFallFlying())) {
            float var29;
            float f2 = var29 = this.player.isFallFlying() ? 300.0f : 100.0f;
            if (var26 - var24 > (double)(var29 * (float)var28) && !this.isSingleplayerOwner()) {
                LOGGER.warn("{} moved too quickly! {},{},{}", (Object)this.player.getName().getString(), (Object)var18, (Object)var20, (Object)var22);
                this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot());
                return;
            }
        }
        AxisAlignedBB var29 = this.player.getBoundingBox();
        var18 = var2 - this.lastGoodX;
        var20 = var4 - this.lastGoodY;
        var22 = var6 - this.lastGoodZ;
        boolean bl = var30 = var20 > 0.0;
        if (this.player.isOnGround() && !var0.isOnGround() && var30) {
            this.player.jumpFromGround();
        }
        this.player.move(EnumMoveType.PLAYER, new Vec3D(var18, var20, var22));
        double var31 = var20;
        var18 = var2 - this.player.getX();
        var20 = var4 - this.player.getY();
        if (var20 > -0.5 || var20 < 0.5) {
            var20 = 0.0;
        }
        var22 = var6 - this.player.getZ();
        var26 = var18 * var18 + var20 * var20 + var22 * var22;
        boolean var33 = false;
        if (!this.player.isChangingDimension() && var26 > 0.0625 && !this.player.isSleeping() && !this.player.gameMode.isCreative() && this.player.gameMode.getGameModeForPlayer() != EnumGamemode.SPECTATOR) {
            var33 = true;
            LOGGER.warn("{} moved wrongly!", (Object)this.player.getName().getString());
        }
        this.player.absMoveTo(var2, var4, var6, var8, var9);
        if (!this.player.noPhysics && !this.player.isSleeping() && (var33 && var1.noCollision(this.player, var29) || this.isPlayerCollidingWithAnythingNew(var1, var29))) {
            this.teleport(var10, var12, var14, var8, var9);
            return;
        }
        this.clientIsFloating = var31 >= -0.03125 && this.player.gameMode.getGameModeForPlayer() != EnumGamemode.SPECTATOR && !this.server.isFlightAllowed() && !this.player.getAbilities().mayfly && !this.player.hasEffect(MobEffects.LEVITATION) && !this.player.isFallFlying() && this.noBlocksAround(this.player);
        this.player.getLevel().getChunkSource().move(this.player);
        this.player.doCheckFallDamage(this.player.getY() - var16, var0.isOnGround());
        this.player.setOnGround(var0.isOnGround());
        if (var30) {
            this.player.resetFallDistance();
        }
        this.player.checkMovementStatistics(this.player.getX() - var10, this.player.getY() - var12, this.player.getZ() - var14);
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    private boolean isPlayerCollidingWithAnythingNew(IWorldReader var0, AxisAlignedBB var1) {
        Iterable<VoxelShape> var2 = var0.getCollisions(this.player, this.player.getBoundingBox().deflate(1.0E-5f));
        VoxelShape var3 = VoxelShapes.create(var1.deflate(1.0E-5f));
        for (VoxelShape var5 : var2) {
            if (VoxelShapes.joinIsNotEmpty(var5, var3, OperatorBoolean.AND)) continue;
            return true;
        }
        return false;
    }

    public void dismount(double var0, double var2, double var4, float var6, float var7) {
        this.teleport(var0, var2, var4, var6, var7, Collections.emptySet(), true);
    }

    public void teleport(double var0, double var2, double var4, float var6, float var7) {
        this.teleport(var0, var2, var4, var6, var7, Collections.emptySet(), false);
    }

    public void teleport(double var0, double var2, double var4, float var6, float var7, Set<PacketPlayOutPosition.EnumPlayerTeleportFlags> var8) {
        this.teleport(var0, var2, var4, var6, var7, var8, false);
    }

    public void teleport(double var0, double var2, double var4, float var6, float var7, Set<PacketPlayOutPosition.EnumPlayerTeleportFlags> var8, boolean var9) {
        double var10 = var8.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.X) ? this.player.getX() : 0.0;
        double var12 = var8.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.Y) ? this.player.getY() : 0.0;
        double var14 = var8.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.Z) ? this.player.getZ() : 0.0;
        float var16 = var8.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.Y_ROT) ? this.player.getYRot() : 0.0f;
        float var17 = var8.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.X_ROT) ? this.player.getXRot() : 0.0f;
        this.awaitingPositionFromClient = new Vec3D(var0, var2, var4);
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.awaitingTeleportTime = this.tickCount;
        this.player.absMoveTo(var0, var2, var4, var6, var7);
        this.player.connection.send(new PacketPlayOutPosition(var0 - var10, var2 - var12, var4 - var14, var6 - var16, var7 - var17, var8, this.awaitingTeleport, var9));
    }

    @Override
    public void handlePlayerAction(PacketPlayInBlockDig var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        BlockPosition var1 = var0.getPos();
        this.player.resetLastActionTime();
        PacketPlayInBlockDig.EnumPlayerDigType var2 = var0.getAction();
        switch (var2) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.player.isSpectator()) {
                    ItemStack var3 = this.player.getItemInHand(EnumHand.OFF_HAND);
                    this.player.setItemInHand(EnumHand.OFF_HAND, this.player.getItemInHand(EnumHand.MAIN_HAND));
                    this.player.setItemInHand(EnumHand.MAIN_HAND, var3);
                    this.player.stopUsingItem();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.player.isSpectator()) {
                    this.player.drop(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.player.isSpectator()) {
                    this.player.drop(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.player.releaseUsingItem();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.player.gameMode.handleBlockBreakAction(var1, var2, var0.getDirection(), this.player.level.getMaxBuildHeight());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean wasBlockPlacementAttempt(EntityPlayer var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return false;
        }
        Item var2 = var1.getItem();
        return (var2 instanceof ItemBlock || var2 instanceof ItemBucket) && !var0.getCooldowns().isOnCooldown(var2);
    }

    @Override
    public void handleUseItemOn(PacketPlayInUseItem var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        WorldServer var1 = this.player.getLevel();
        EnumHand var2 = var0.getHand();
        ItemStack var3 = this.player.getItemInHand(var2);
        MovingObjectPositionBlock var4 = var0.getHitResult();
        BlockPosition var5 = var4.getBlockPos();
        EnumDirection var6 = var4.getDirection();
        this.player.resetLastActionTime();
        int var7 = this.player.level.getMaxBuildHeight();
        if (var5.getY() < var7) {
            if (this.awaitingPositionFromClient == null && this.player.distanceToSqr((double)var5.getX() + 0.5, (double)var5.getY() + 0.5, (double)var5.getZ() + 0.5) < 64.0 && var1.mayInteract(this.player, var5)) {
                EnumInteractionResult var8 = this.player.gameMode.useItemOn(this.player, var1, var3, var2, var4);
                if (var6 == EnumDirection.UP && !var8.consumesAction() && var5.getY() >= var7 - 1 && PlayerConnection.wasBlockPlacementAttempt(this.player, var3)) {
                    IChatMutableComponent var9 = new ChatMessage("build.tooHigh", var7 - 1).withStyle(EnumChatFormat.RED);
                    this.player.sendMessage(var9, ChatMessageType.GAME_INFO, SystemUtils.NIL_UUID);
                } else if (var8.shouldSwing()) {
                    this.player.swing(var2, true);
                }
            }
        } else {
            IChatMutableComponent var8 = new ChatMessage("build.tooHigh", var7 - 1).withStyle(EnumChatFormat.RED);
            this.player.sendMessage(var8, ChatMessageType.GAME_INFO, SystemUtils.NIL_UUID);
        }
        this.player.connection.send(new PacketPlayOutBlockChange(var1, var5));
        this.player.connection.send(new PacketPlayOutBlockChange(var1, var5.relative(var6)));
    }

    @Override
    public void handleUseItem(PacketPlayInBlockPlace var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        WorldServer var1 = this.player.getLevel();
        EnumHand var2 = var0.getHand();
        ItemStack var3 = this.player.getItemInHand(var2);
        this.player.resetLastActionTime();
        if (var3.isEmpty()) {
            return;
        }
        EnumInteractionResult var4 = this.player.gameMode.useItem(this.player, var1, var3, var2);
        if (var4.shouldSwing()) {
            this.player.swing(var2, true);
        }
    }

    @Override
    public void handleTeleportToEntityPacket(PacketPlayInSpectate var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (this.player.isSpectator()) {
            for (WorldServer var2 : this.server.getAllLevels()) {
                Entity var3 = var0.getEntity(var2);
                if (var3 == null) continue;
                this.player.teleportTo(var2, var3.getX(), var3.getY(), var3.getZ(), var3.getYRot(), var3.getXRot());
                return;
            }
        }
    }

    @Override
    public void handleResourcePackResponse(PacketPlayInResourcePackStatus var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (var0.getAction() == PacketPlayInResourcePackStatus.EnumResourcePackStatus.DECLINED && this.server.isResourcePackRequired()) {
            LOGGER.info("Disconnecting {} due to resource pack rejection", (Object)this.player.getName());
            this.disconnect(new ChatMessage("multiplayer.requiredTexturePrompt.disconnect"));
        }
    }

    @Override
    public void handlePaddleBoat(PacketPlayInBoatMove var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        Entity var1 = this.player.getVehicle();
        if (var1 instanceof EntityBoat) {
            ((EntityBoat)var1).setPaddleState(var0.getLeft(), var0.getRight());
        }
    }

    @Override
    public void handlePong(ServerboundPongPacket var0) {
    }

    @Override
    public void onDisconnect(IChatBaseComponent var0) {
        LOGGER.info("{} lost connection: {}", (Object)this.player.getName().getString(), (Object)var0.getString());
        this.server.invalidateStatus();
        this.server.getPlayerList().broadcastMessage(new ChatMessage("multiplayer.player.left", this.player.getDisplayName()).withStyle(EnumChatFormat.YELLOW), ChatMessageType.SYSTEM, SystemUtils.NIL_UUID);
        this.player.disconnect();
        this.server.getPlayerList().remove(this.player);
        this.player.getTextFilter().leave();
        if (this.isSingleplayerOwner()) {
            LOGGER.info("Stopping singleplayer server as player logged out");
            this.server.halt(false);
        }
    }

    @Override
    public void send(Packet<?> var0) {
        this.send(var0, null);
    }

    public void send(Packet<?> var0, @Nullable GenericFutureListener<? extends Future<? super Void>> var1) {
        try {
            this.connection.send(var0, var1);
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Sending packet");
            CrashReportSystemDetails var4 = var3.addCategory("Packet being sent");
            var4.setDetail("Packet class", () -> var0.getClass().getCanonicalName());
            throw new ReportedException(var3);
        }
    }

    @Override
    public void handleSetCarriedItem(PacketPlayInHeldItemSlot var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (var0.getSlot() < 0 || var0.getSlot() >= PlayerInventory.getSelectionSize()) {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getName().getString());
            return;
        }
        if (this.player.getInventory().selected != var0.getSlot() && this.player.getUsedItemHand() == EnumHand.MAIN_HAND) {
            this.player.stopUsingItem();
        }
        this.player.getInventory().selected = var0.getSlot();
        this.player.resetLastActionTime();
    }

    @Override
    public void handleChat(PacketPlayInChat var0) {
        String var1 = StringUtils.normalizeSpace((String)var0.getMessage());
        for (int var2 = 0; var2 < var1.length(); ++var2) {
            if (SharedConstants.isAllowedChatCharacter(var1.charAt(var2))) continue;
            this.disconnect(new ChatMessage("multiplayer.disconnect.illegal_characters"));
            return;
        }
        if (var1.startsWith("/")) {
            PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
            this.handleChat(ITextFilter.a.passThrough(var1));
        } else {
            this.filterTextPacket(var1, this::handleChat);
        }
    }

    private void handleChat(ITextFilter.a var0) {
        if (this.player.getChatVisibility() == EnumChatVisibility.HIDDEN) {
            this.send(new PacketPlayOutChat(new ChatMessage("chat.disabled.options").withStyle(EnumChatFormat.RED), ChatMessageType.SYSTEM, SystemUtils.NIL_UUID));
            return;
        }
        this.player.resetLastActionTime();
        String var1 = var0.getRaw();
        if (var1.startsWith("/")) {
            this.handleCommand(var1);
        } else {
            String var22 = var0.getFiltered();
            ChatMessage var3 = var22.isEmpty() ? null : new ChatMessage("chat.type.text", this.player.getDisplayName(), var22);
            ChatMessage var4 = new ChatMessage("chat.type.text", this.player.getDisplayName(), var1);
            this.server.getPlayerList().broadcastMessage(var4, var2 -> this.player.shouldFilterMessageTo((EntityPlayer)var2) ? var3 : var4, ChatMessageType.CHAT, this.player.getUUID());
        }
        this.chatSpamTickCount += 20;
        if (this.chatSpamTickCount > 200 && !this.server.getPlayerList().isOp(this.player.getGameProfile())) {
            this.disconnect(new ChatMessage("disconnect.spam"));
        }
    }

    private void handleCommand(String var0) {
        this.server.getCommands().performCommand(this.player.createCommandSourceStack(), var0);
    }

    @Override
    public void handleAnimate(PacketPlayInArmAnimation var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        this.player.swing(var0.getHand());
    }

    @Override
    public void handlePlayerCommand(PacketPlayInEntityAction var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        switch (var0.getAction()) {
            case PRESS_SHIFT_KEY: {
                this.player.setShiftKeyDown(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.player.setShiftKeyDown(false);
                break;
            }
            case START_SPRINTING: {
                this.player.setSprinting(true);
                break;
            }
            case STOP_SPRINTING: {
                this.player.setSprinting(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.player.isSleeping()) break;
                this.player.stopSleepInBed(false, true);
                this.awaitingPositionFromClient = this.player.position();
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.player.getVehicle() instanceof IJumpable)) break;
                IJumpable var1 = (IJumpable)((Object)this.player.getVehicle());
                int var2 = var0.getData();
                if (!var1.canJump() || var2 <= 0) break;
                var1.handleStartJump(var2);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.player.getVehicle() instanceof IJumpable)) break;
                IJumpable var1 = (IJumpable)((Object)this.player.getVehicle());
                var1.handleStopJump();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.player.getVehicle() instanceof EntityHorseAbstract)) break;
                ((EntityHorseAbstract)this.player.getVehicle()).openInventory(this.player);
                break;
            }
            case START_FALL_FLYING: {
                if (this.player.tryToStartFallFlying()) break;
                this.player.stopFallFlying();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    @Override
    public void handleInteract(PacketPlayInUseEntity var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        WorldServer var1 = this.player.getLevel();
        final Entity var2 = var0.getTarget(var1);
        this.player.resetLastActionTime();
        this.player.setShiftKeyDown(var0.isUsingSecondaryAction());
        if (var2 != null) {
            if (!var1.getWorldBorder().isWithinBounds(var2.blockPosition())) {
                return;
            }
            double var3 = 36.0;
            if (this.player.distanceToSqr(var2) < 36.0) {
                var0.dispatch(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand var0, a var1) {
                        ItemStack var22 = PlayerConnection.this.player.getItemInHand(var0).copy();
                        EnumInteractionResult var3 = var1.run(PlayerConnection.this.player, var2, var0);
                        if (var3.consumesAction()) {
                            CriterionTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(PlayerConnection.this.player, var22, var2);
                            if (var3.shouldSwing()) {
                                PlayerConnection.this.player.swing(var0, true);
                            }
                        }
                    }

                    @Override
                    public void onInteraction(EnumHand var0) {
                        this.performInteraction(var0, EntityHuman::interactOn);
                    }

                    @Override
                    public void onInteraction(EnumHand var0, Vec3D var12) {
                        this.performInteraction(var0, (var1, var2, var3) -> var2.interactAt(var1, var12, var3));
                    }

                    @Override
                    public void onAttack() {
                        if (var2 instanceof EntityItem || var2 instanceof EntityExperienceOrb || var2 instanceof EntityArrow || var2 == PlayerConnection.this.player) {
                            PlayerConnection.this.disconnect(new ChatMessage("multiplayer.disconnect.invalid_entity_attacked"));
                            LOGGER.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.player.getName().getString());
                            return;
                        }
                        PlayerConnection.this.player.attack(var2);
                    }
                });
            }
        }
    }

    @Override
    public void handleClientCommand(PacketPlayInClientCommand var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        PacketPlayInClientCommand.EnumClientCommand var1 = var0.getAction();
        switch (var1) {
            case PERFORM_RESPAWN: {
                if (this.player.wonGame) {
                    this.player.wonGame = false;
                    this.player = this.server.getPlayerList().respawn(this.player, true);
                    CriterionTriggers.CHANGED_DIMENSION.trigger(this.player, World.END, World.OVERWORLD);
                    break;
                }
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.server.getPlayerList().respawn(this.player, false);
                if (!this.server.isHardcore()) break;
                this.player.setGameMode(EnumGamemode.SPECTATOR);
                this.player.getLevel().getGameRules().getRule(GameRules.RULE_SPECTATORSGENERATECHUNKS).set(false, this.server);
                break;
            }
            case REQUEST_STATS: {
                this.player.getStats().sendStats(this.player);
            }
        }
    }

    @Override
    public void handleContainerClose(PacketPlayInCloseWindow var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.doCloseContainer();
    }

    @Override
    public void handleContainerClick(PacketPlayInWindowClick var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == var0.getContainerId()) {
            if (this.player.isSpectator()) {
                this.player.containerMenu.sendAllDataToRemote();
            } else {
                boolean var1 = var0.getStateId() != this.player.containerMenu.getStateId();
                this.player.containerMenu.suppressRemoteUpdates();
                this.player.containerMenu.clicked(var0.getSlotNum(), var0.getButtonNum(), var0.getClickType(), this.player);
                for (Int2ObjectMap.Entry var3 : Int2ObjectMaps.fastIterable(var0.getChangedSlots())) {
                    this.player.containerMenu.setRemoteSlotNoCopy(var3.getIntKey(), (ItemStack)var3.getValue());
                }
                this.player.containerMenu.setRemoteCarried(var0.getCarriedItem());
                this.player.containerMenu.resumeRemoteUpdates();
                if (var1) {
                    this.player.containerMenu.broadcastFullState();
                } else {
                    this.player.containerMenu.broadcastChanges();
                }
            }
        }
    }

    @Override
    public void handlePlaceRecipe(PacketPlayInAutoRecipe var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        if (this.player.isSpectator() || this.player.containerMenu.containerId != var0.getContainerId() || !(this.player.containerMenu instanceof ContainerRecipeBook)) {
            return;
        }
        this.server.getRecipeManager().byKey(var0.getRecipe()).ifPresent(var1 -> ((ContainerRecipeBook)this.player.containerMenu).handlePlacement(var0.isShiftDown(), (IRecipe<?>)var1, this.player));
    }

    @Override
    public void handleContainerButtonClick(PacketPlayInEnchantItem var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == var0.getContainerId() && !this.player.isSpectator()) {
            this.player.containerMenu.clickMenuButton(this.player, var0.getButtonId());
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void handleSetCreativeModeSlot(PacketPlayInSetCreativeSlot var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (this.player.gameMode.isCreative()) {
            boolean var5;
            BlockPosition var4;
            TileEntity var52;
            boolean var1 = var0.getSlotNum() < 0;
            ItemStack var2 = var0.getItem();
            NBTTagCompound var3 = ItemBlock.getBlockEntityData(var2);
            if (!var2.isEmpty() && var3 != null && var3.contains("x") && var3.contains("y") && var3.contains("z") && (var52 = this.player.level.getBlockEntity(var4 = TileEntity.getPosFromTag(var3))) != null) {
                var52.saveToItem(var2);
            }
            boolean var42 = var0.getSlotNum() >= 1 && var0.getSlotNum() <= 45;
            boolean bl = var5 = var2.isEmpty() || var2.getDamageValue() >= 0 && var2.getCount() <= 64 && !var2.isEmpty();
            if (var42 && var5) {
                this.player.inventoryMenu.getSlot(var0.getSlotNum()).set(var2);
                this.player.inventoryMenu.broadcastChanges();
            } else if (var1 && var5 && this.dropSpamTickCount < 200) {
                this.dropSpamTickCount += 20;
                this.player.drop(var2, true);
            }
        }
    }

    @Override
    public void handleSignUpdate(PacketPlayInUpdateSign var0) {
        List<String> var12 = Stream.of(var0.getLines()).map(EnumChatFormat::stripFormatting).collect(Collectors.toList());
        this.filterTextPacket(var12, (List<ITextFilter.a> var1) -> this.updateSignText(var0, (List<ITextFilter.a>)var1));
    }

    private void updateSignText(PacketPlayInUpdateSign var0, List<ITextFilter.a> var1) {
        this.player.resetLastActionTime();
        WorldServer var2 = this.player.getLevel();
        BlockPosition var3 = var0.getPos();
        if (var2.hasChunkAt(var3)) {
            IBlockData var4 = var2.getBlockState(var3);
            TileEntity var5 = var2.getBlockEntity(var3);
            if (!(var5 instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign var6 = (TileEntitySign)var5;
            if (!var6.isEditable() || !this.player.getUUID().equals(var6.getPlayerWhoMayEdit())) {
                LOGGER.warn("Player {} just tried to change non-editable sign", (Object)this.player.getName().getString());
                return;
            }
            for (int var7 = 0; var7 < var1.size(); ++var7) {
                ITextFilter.a var8 = var1.get(var7);
                if (this.player.isTextFilteringEnabled()) {
                    var6.setMessage(var7, new ChatComponentText(var8.getFiltered()));
                    continue;
                }
                var6.setMessage(var7, new ChatComponentText(var8.getRaw()), new ChatComponentText(var8.getFiltered()));
            }
            var6.setChanged();
            var2.sendBlockUpdated(var3, var4, var4, 3);
        }
    }

    @Override
    public void handleKeepAlive(PacketPlayInKeepAlive var0) {
        if (this.keepAlivePending && var0.getId() == this.keepAliveChallenge) {
            int var1 = (int)(SystemUtils.getMillis() - this.keepAliveTime);
            this.player.latency = (this.player.latency * 3 + var1) / 4;
            this.keepAlivePending = false;
        } else if (!this.isSingleplayerOwner()) {
            this.disconnect(new ChatMessage("disconnect.timeout"));
        }
    }

    @Override
    public void handlePlayerAbilities(PacketPlayInAbilities var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.getAbilities().flying = var0.isFlying() && this.player.getAbilities().mayfly;
    }

    @Override
    public void handleClientInformation(PacketPlayInSettings var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.updateOptions(var0);
    }

    @Override
    public void handleCustomPayload(PacketPlayInCustomPayload var0) {
    }

    @Override
    public void handleChangeDifficulty(PacketPlayInDifficultyChange var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            return;
        }
        this.server.setDifficulty(var0.getDifficulty(), false);
    }

    @Override
    public void handleLockDifficulty(PacketPlayInDifficultyLock var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            return;
        }
        this.server.setDifficultyLocked(var0.isLocked());
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @FunctionalInterface
    static interface a {
        public EnumInteractionResult run(EntityPlayer var1, Entity var2, EnumHand var3);
    }
}

