/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.status.PacketStatusInListener;
import net.minecraft.network.protocol.status.PacketStatusInPing;
import net.minecraft.network.protocol.status.PacketStatusInStart;
import net.minecraft.network.protocol.status.PacketStatusOutPong;
import net.minecraft.network.protocol.status.PacketStatusOutServerInfo;
import net.minecraft.server.MinecraftServer;

public class PacketStatusListener
implements PacketStatusInListener {
    private static final IChatBaseComponent DISCONNECT_REASON = new ChatMessage("multiplayer.status.request_handled");
    private final MinecraftServer server;
    private final NetworkManager connection;
    private boolean hasRequestedStatus;

    public PacketStatusListener(MinecraftServer var0, NetworkManager var1) {
        this.server = var0;
        this.connection = var1;
    }

    @Override
    public void onDisconnect(IChatBaseComponent var0) {
    }

    @Override
    public NetworkManager getConnection() {
        return this.connection;
    }

    @Override
    public void handleStatusRequest(PacketStatusInStart var0) {
        if (this.hasRequestedStatus) {
            this.connection.disconnect(DISCONNECT_REASON);
            return;
        }
        this.hasRequestedStatus = true;
        this.connection.send(new PacketStatusOutServerInfo(this.server.getStatus()));
    }

    @Override
    public void handlePingRequest(PacketStatusInPing var0) {
        this.connection.send(new PacketStatusOutPong(var0.getTime()));
        this.connection.disconnect(DISCONNECT_REASON);
    }
}

