/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.SharedConstants;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PacketStatusListener;

public class HandshakeListener
implements PacketHandshakingInListener {
    private static final IChatBaseComponent IGNORE_STATUS_REASON = new ChatComponentText("Ignoring status request");
    private final MinecraftServer server;
    private final NetworkManager connection;

    public HandshakeListener(MinecraftServer var0, NetworkManager var1) {
        this.server = var0;
        this.connection = var1;
    }

    @Override
    public void handleIntention(PacketHandshakingInSetProtocol var0) {
        switch (var0.getIntention()) {
            case LOGIN: {
                this.connection.setProtocol(EnumProtocol.LOGIN);
                if (var0.getProtocolVersion() != SharedConstants.getCurrentVersion().getProtocolVersion()) {
                    ChatMessage var1 = var0.getProtocolVersion() < 754 ? new ChatMessage("multiplayer.disconnect.outdated_client", SharedConstants.getCurrentVersion().getName()) : new ChatMessage("multiplayer.disconnect.incompatible", SharedConstants.getCurrentVersion().getName());
                    this.connection.send(new PacketLoginOutDisconnect(var1));
                    this.connection.disconnect(var1);
                    break;
                }
                this.connection.setListener(new LoginListener(this.server, this.connection));
                break;
            }
            case STATUS: {
                if (this.server.repliesToStatus()) {
                    this.connection.setProtocol(EnumProtocol.STATUS);
                    this.connection.setListener(new PacketStatusListener(this.server, this.connection));
                    break;
                }
                this.connection.disconnect(IGNORE_STATUS_REASON);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + var0.getIntention());
            }
        }
    }

    @Override
    public void onDisconnect(IChatBaseComponent var0) {
    }

    @Override
    public NetworkManager getConnection() {
        return this.connection;
    }
}

