/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkTaskQueueSorter
implements PlayerChunk.d,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Mailbox<?>, ChunkTaskQueue<? extends Function<Mailbox<Unit>, ?>>> queues;
    private final Set<Mailbox<?>> sleeping;
    private final ThreadedMailbox<PairedQueue.b> mailbox;

    public ChunkTaskQueueSorter(List<Mailbox<?>> var0, Executor var12, int var2) {
        this.queues = var0.stream().collect(Collectors.toMap(Function.identity(), var1 -> new ChunkTaskQueue(var1.name() + "_queue", var2)));
        this.sleeping = Sets.newHashSet(var0);
        this.mailbox = new ThreadedMailbox<PairedQueue.b>(new PairedQueue.a(4), var12, "sorter");
    }

    public static <T> a<T> message(Function<Mailbox<Unit>, T> var0, long var1, IntSupplier var3) {
        return new a<T>(var0, var1, var3);
    }

    public static a<Runnable> message(Runnable var0, long var12, IntSupplier var3) {
        return new a<Runnable>(var1 -> () -> {
            var0.run();
            var1.tell(Unit.INSTANCE);
        }, var12, var3);
    }

    public static a<Runnable> message(PlayerChunk var0, Runnable var1) {
        return ChunkTaskQueueSorter.message(var1, var0.getPos().toLong(), var0::getQueueLevel);
    }

    public static <T> a<T> message(PlayerChunk var0, Function<Mailbox<Unit>, T> var1) {
        return ChunkTaskQueueSorter.message(var1, var0.getPos().toLong(), var0::getQueueLevel);
    }

    public static b release(Runnable var0, long var1, boolean var3) {
        return new b(var0, var1, var3);
    }

    public <T> Mailbox<a<T>> getProcessor(Mailbox<T> var0, boolean var1) {
        return (Mailbox)this.mailbox.ask(var2 -> new PairedQueue.b(0, () -> {
            this.getQueue(var0);
            var2.tell(Mailbox.of("chunk priority sorter around " + var0.name(), var2 -> this.submit(var0, var2.task, var2.pos, var2.level, var1)));
        })).join();
    }

    public Mailbox<b> getReleaseProcessor(Mailbox<Runnable> var0) {
        return (Mailbox)this.mailbox.ask(var1 -> new PairedQueue.b(0, () -> var1.tell(Mailbox.of("chunk priority sorter around " + var0.name(), var1 -> this.release(var0, var1.pos, var1.task, var1.clearQueue))))).join();
    }

    @Override
    public void onLevelChange(ChunkCoordIntPair var0, IntSupplier var1, int var2, IntConsumer var3) {
        this.mailbox.tell(new PairedQueue.b(0, () -> {
            int var4 = var1.getAsInt();
            this.queues.values().forEach(var3 -> var3.resortChunkTasks(var4, var0, var2));
            var3.accept(var2);
        }));
    }

    private <T> void release(Mailbox<T> var0, long var1, Runnable var3, boolean var4) {
        this.mailbox.tell(new PairedQueue.b(1, () -> {
            ChunkTaskQueue var5 = this.getQueue(var0);
            var5.release(var1, var4);
            if (this.sleeping.remove(var0)) {
                this.pollTask(var5, var0);
            }
            var3.run();
        }));
    }

    private <T> void submit(Mailbox<T> var0, Function<Mailbox<Unit>, T> var1, long var2, IntSupplier var4, boolean var5) {
        this.mailbox.tell(new PairedQueue.b(2, () -> {
            ChunkTaskQueue var6 = this.getQueue(var0);
            int var7 = var4.getAsInt();
            var6.submit(Optional.of(var1), var2, var7);
            if (var5) {
                var6.submit(Optional.empty(), var2, var7);
            }
            if (this.sleeping.remove(var0)) {
                this.pollTask(var6, var0);
            }
        }));
    }

    private <T> void pollTask(ChunkTaskQueue<Function<Mailbox<Unit>, T>> var0, Mailbox<T> var1) {
        this.mailbox.tell(new PairedQueue.b(3, () -> {
            Stream<Either<Either, Runnable>> var22 = var0.pop();
            if (var22 == null) {
                this.sleeping.add(var1);
            } else {
                SystemUtils.sequence(var22.map(var1 -> (CompletableFuture)var1.map(var1::ask, var0 -> {
                    var0.run();
                    return CompletableFuture.completedFuture(Unit.INSTANCE);
                })).collect(Collectors.toList())).thenAccept(var2 -> this.pollTask(var0, var1));
            }
        }));
    }

    private <T> ChunkTaskQueue<Function<Mailbox<Unit>, T>> getQueue(Mailbox<T> var0) {
        ChunkTaskQueue<Function<Mailbox<Unit>, T>> var1 = this.queues.get(var0);
        if (var1 == null) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException("No queue for: " + var0));
        }
        return var1;
    }

    @VisibleForTesting
    public String getDebugStatus() {
        return this.queues.entrySet().stream().map(var02 -> ((Mailbox)var02.getKey()).name() + "=[" + ((ChunkTaskQueue)var02.getValue()).getAcquired().stream().map(var0 -> var0 + ":" + new ChunkCoordIntPair((long)var0)).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(",")) + ", s=" + this.sleeping.size();
    }

    @Override
    public void close() {
        this.queues.keySet().forEach(Mailbox::close);
    }

    public static final class a<T> {
        final Function<Mailbox<Unit>, T> task;
        final long pos;
        final IntSupplier level;

        a(Function<Mailbox<Unit>, T> var0, long var1, IntSupplier var3) {
            this.task = var0;
            this.pos = var1;
            this.level = var3;
        }
    }

    public static final class b {
        final Runnable task;
        final long pos;
        final boolean clearQueue;

        b(Runnable var0, long var1, boolean var3) {
            this.task = var0;
            this.pos = var1;
            this.clearQueue = var3;
        }
    }
}

