/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Streams;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SystemUtils;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.GameRules;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadWatchdog
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long MAX_SHUTDOWN_TIME = 10000L;
    private static final int SHUTDOWN_STATUS = 1;
    private final DedicatedServer server;
    private final long maxTickTime;

    public ThreadWatchdog(DedicatedServer var0) {
        this.server = var0;
        this.maxTickTime = var0.getMaxTickLength();
    }

    @Override
    public void run() {
        while (this.server.isRunning()) {
            long var0 = this.server.getNextTickTime();
            long var2 = SystemUtils.getMillis();
            long var4 = var2 - var0;
            if (var4 > this.maxTickTime) {
                LOGGER.fatal("A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var4 / 1000.0f)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(0.05f)));
                LOGGER.fatal("Considering it to be crashed, server will forcibly shutdown.");
                ThreadMXBean var6 = ManagementFactory.getThreadMXBean();
                ThreadInfo[] var7 = var6.dumpAllThreads(true, true);
                StringBuilder var8 = new StringBuilder();
                Error var9 = new Error("Watchdog");
                for (ThreadInfo threadInfo : var7) {
                    if (threadInfo.getThreadId() == this.server.getRunningThread().getId()) {
                        var9.setStackTrace(threadInfo.getStackTrace());
                    }
                    var8.append(threadInfo);
                    var8.append("\n");
                }
                CrashReport var10 = new CrashReport("Watching Server", var9);
                this.server.fillSystemReport(var10.getSystemReport());
                CrashReportSystemDetails var11 = var10.addCategory("Thread Dump");
                var11.setDetail("Threads", var8);
                CrashReportSystemDetails var12 = var10.addCategory("Performance stats");
                var12.setDetail("Random tick rate", () -> this.server.getWorldData().getGameRules().getRule(GameRules.RULE_RANDOMTICKING).toString());
                var12.setDetail("Level stats", () -> Streams.stream(this.server.getAllLevels()).map(var0 -> var0.dimension() + ": " + var0.getWatchdogStats()).collect(Collectors.joining(",\n")));
                DispenserRegistry.realStdoutPrintln("Crash report:\n" + var10.getFriendlyReport());
                File file = new File(new File(this.server.getServerDirectory(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
                if (var10.saveToFile(file)) {
                    LOGGER.error("This crash report has been saved to: {}", (Object)file.getAbsolutePath());
                } else {
                    LOGGER.error("We were unable to save this crash report to disk.");
                }
                this.exit();
            }
            try {
                Thread.sleep(var0 + this.maxTickTime - var2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void exit() {
        try {
            Timer var0 = new Timer();
            var0.schedule(new TimerTask(){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable var0) {
            Runtime.getRuntime().halt(1);
        }
    }
}

