/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Map;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;

public class CommandLocate {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new ChatMessage("commands.locate.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralArgumentBuilder var12 = (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("locate").requires(var0 -> var0.hasPermission(2));
        for (Map.Entry var3 : StructureGenerator.STRUCTURES_REGISTRY.entrySet()) {
            var12 = (LiteralArgumentBuilder)var12.then(net.minecraft.commands.CommandDispatcher.literal((String)var3.getKey()).executes(var1 -> CommandLocate.locate((CommandListenerWrapper)var1.getSource(), (StructureGenerator)var3.getValue())));
        }
        var02.register(var12);
    }

    private static int locate(CommandListenerWrapper var0, StructureGenerator<?> var1) throws CommandSyntaxException {
        BlockPosition var2 = new BlockPosition(var0.getPosition());
        BlockPosition var3 = var0.getLevel().findNearestMapFeature(var1, var2, 100, false);
        if (var3 == null) {
            throw ERROR_FAILED.create();
        }
        return CommandLocate.showLocateResult(var0, var1.getFeatureName(), var2, var3, "commands.locate.success");
    }

    public static int showLocateResult(CommandListenerWrapper var0, String var12, BlockPosition var2, BlockPosition var3, String var4) {
        int var5 = MathHelper.floor(CommandLocate.dist(var2.getX(), var2.getZ(), var3.getX(), var3.getZ()));
        IChatMutableComponent var6 = ChatComponentUtils.wrapInSquareBrackets(new ChatMessage("chat.coordinates", var3.getX(), "~", var3.getZ())).withStyle(var1 -> var1.withColor(EnumChatFormat.GREEN).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, "/tp @s " + var3.getX() + " ~ " + var3.getZ())).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, new ChatMessage("chat.coordinates.tooltip"))));
        var0.sendSuccess(new ChatMessage(var4, var12, var6, var5), false);
        return var5;
    }

    private static float dist(int var0, int var1, int var2, int var3) {
        int var4 = var2 - var0;
        int var5 = var3 - var1;
        return MathHelper.sqrt(var4 * var4 + var5 * var5);
    }
}

