/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.Advancements;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementDataWorld
extends ResourceDataJson {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON = new GsonBuilder().create();
    public Advancements advancements = new Advancements();
    private final LootPredicateManager predicateManager;

    public AdvancementDataWorld(LootPredicateManager var0) {
        super(GSON, "advancements");
        this.predicateManager = var0;
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var0, IResourceManager var12, GameProfilerFiller var22) {
        HashMap var3 = Maps.newHashMap();
        var0.forEach((var1, var2) -> {
            try {
                JsonObject var3 = ChatDeserializer.convertToJsonObject(var2, "advancement");
                Advancement.SerializedAdvancement var4 = Advancement.SerializedAdvancement.fromJson(var3, new LootDeserializationContext((MinecraftKey)var1, this.predicateManager));
                var3.put(var1, var4);
            }
            catch (Exception var3) {
                LOGGER.error("Parsing error loading custom advancement {}: {}", var1, (Object)var3.getMessage());
            }
        });
        Advancements var4 = new Advancements();
        var4.add(var3);
        for (Advancement var6 : var4.getRoots()) {
            if (var6.getDisplay() == null) continue;
            AdvancementTree.run(var6);
        }
        this.advancements = var4;
    }

    @Nullable
    public Advancement getAdvancement(MinecraftKey var0) {
        return this.advancements.get(var0);
    }

    public Collection<Advancement> getAllAdvancements() {
        return this.advancements.getAllAdvancements();
    }
}

