/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryWriteOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface RegistryResourceAccess {
    public <E> Collection<ResourceKey<E>> listResources(ResourceKey<? extends IRegistry<E>> var1);

    public <E> Optional<DataResult<ParsedEntry<E>>> parseElement(DynamicOps<JsonElement> var1, ResourceKey<? extends IRegistry<E>> var2, ResourceKey<E> var3, Decoder<E> var4);

    public static RegistryResourceAccess forResourceManager(final IResourceManager var0) {
        return new RegistryResourceAccess(){
            private static final String JSON = ".json";

            @Override
            public <E> Collection<ResourceKey<E>> listResources(ResourceKey<? extends IRegistry<E>> var02) {
                String var1 = 1.registryDirPath(var02);
                HashSet var2 = new HashSet();
                var0.listResources(var1, var0 -> var0.endsWith(JSON)).forEach(var3 -> {
                    String var4 = var3.getPath();
                    String var5 = var4.substring(var1.length() + 1, var4.length() - JSON.length());
                    var2.add(ResourceKey.create(var02, new MinecraftKey(var3.getNamespace(), var5)));
                });
                return var2;
            }

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            public <E> Optional<DataResult<ParsedEntry<E>>> parseElement(DynamicOps<JsonElement> var02, ResourceKey<? extends IRegistry<E>> var1, ResourceKey<E> var2, Decoder<E> var3) {
                MinecraftKey var4 = 1.elementPath(var1, var2);
                if (!var0.hasResource(var4)) {
                    return Optional.empty();
                }
                try (IResource var5 = var0.getResource(var4);){
                    Optional<DataResult<ParsedEntry<E>>> optional;
                    try (InputStreamReader var6 = new InputStreamReader(var5.getInputStream(), StandardCharsets.UTF_8);){
                        JsonElement var7 = JsonParser.parseReader((Reader)var6);
                        optional = Optional.of(var3.parse(var02, (Object)var7).map(ParsedEntry::createWithoutId));
                    }
                    return optional;
                }
                catch (JsonIOException | JsonSyntaxException | IOException var52) {
                    return Optional.of(DataResult.error((String)("Failed to parse " + var4 + " file: " + var52.getMessage())));
                }
            }

            private static String registryDirPath(ResourceKey<? extends IRegistry<?>> var02) {
                return var02.location().getPath();
            }

            private static <E> MinecraftKey elementPath(ResourceKey<? extends IRegistry<E>> var02, ResourceKey<E> var1) {
                return new MinecraftKey(var1.location().getNamespace(), 1.registryDirPath(var02) + "/" + var1.location().getPath() + JSON);
            }

            public String toString() {
                return "ResourceAccess[" + var0 + "]";
            }
        };
    }

    public static final class InMemoryStorage
    implements RegistryResourceAccess {
        private static final Logger LOGGER = LogManager.getLogger();
        private final Map<ResourceKey<?>, Entry> entries = Maps.newIdentityHashMap();

        public <E> void add(IRegistryCustom.Dimension var0, ResourceKey<E> var1, Encoder<E> var2, int var3, E var4, Lifecycle var5) {
            DataResult var6 = var2.encodeStart(RegistryWriteOps.create(JsonOps.INSTANCE, var0), var4);
            Optional var7 = var6.error();
            if (var7.isPresent()) {
                LOGGER.error("Error adding element: {}", (Object)((DataResult.PartialResult)var7.get()).message());
            } else {
                this.entries.put(var1, new Entry((JsonElement)var6.result().get(), var3, var5));
            }
        }

        @Override
        public <E> Collection<ResourceKey<E>> listResources(ResourceKey<? extends IRegistry<E>> var0) {
            return this.entries.keySet().stream().flatMap(var1 -> var1.cast(var0).stream()).collect(Collectors.toList());
        }

        @Override
        public <E> Optional<DataResult<ParsedEntry<E>>> parseElement(DynamicOps<JsonElement> var0, ResourceKey<? extends IRegistry<E>> var12, ResourceKey<E> var2, Decoder<E> var3) {
            Entry var4 = this.entries.get(var2);
            if (var4 == null) {
                return Optional.of(DataResult.error((String)("Unknown element: " + var2)));
            }
            return Optional.of(var3.parse(var0, (Object)var4.data).setLifecycle(var4.lifecycle).map(var1 -> ParsedEntry.createWithId(var1, var0.id)));
        }

        static final class Entry
        extends Record {
            final JsonElement data;
            final int id;
            final Lifecycle lifecycle;

            Entry(JsonElement var0, int var1, Lifecycle var2) {
                this.data = var0;
                this.id = var1;
                this.lifecycle = var2;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "data;id;lifecycle", "data", "id", "lifecycle"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "data;id;lifecycle", "data", "id", "lifecycle"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "data;id;lifecycle", "data", "id", "lifecycle"}, this, var0);
            }

            public JsonElement data() {
                return this.data;
            }

            public int id() {
                return this.id;
            }

            public Lifecycle lifecycle() {
                return this.lifecycle;
            }
        }
    }

    public record ParsedEntry<E>(E value, OptionalInt fixedId) {
        public static <E> ParsedEntry<E> createWithoutId(E var0) {
            return new ParsedEntry<E>(var0, OptionalInt.empty());
        }

        public static <E> ParsedEntry<E> createWithId(E var0, int var1) {
            return new ParsedEntry<E>(var0, OptionalInt.of(var1));
        }
    }
}

