/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.DynamicOpsWrapper;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResourceManager;

public class RegistryReadOps<T>
extends DynamicOpsWrapper<T> {
    private final RegistryResourceAccess resources;
    private final IRegistryCustom registryAccess;
    private final Map<ResourceKey<? extends IRegistry<?>>, a<?>> readCache;
    private final RegistryReadOps<JsonElement> jsonOps;

    public static <T> RegistryReadOps<T> createAndLoad(DynamicOps<T> var0, IResourceManager var1, IRegistryCustom var2) {
        return RegistryReadOps.createAndLoad(var0, RegistryResourceAccess.forResourceManager(var1), var2);
    }

    public static <T> RegistryReadOps<T> createAndLoad(DynamicOps<T> var0, RegistryResourceAccess var1, IRegistryCustom var2) {
        RegistryReadOps<T> var3 = new RegistryReadOps<T>(var0, var1, var2, Maps.newIdentityHashMap());
        IRegistryCustom.load(var2, var3);
        return var3;
    }

    public static <T> RegistryReadOps<T> create(DynamicOps<T> var0, IResourceManager var1, IRegistryCustom var2) {
        return RegistryReadOps.create(var0, RegistryResourceAccess.forResourceManager(var1), var2);
    }

    public static <T> RegistryReadOps<T> create(DynamicOps<T> var0, RegistryResourceAccess var1, IRegistryCustom var2) {
        return new RegistryReadOps<T>(var0, var1, var2, Maps.newIdentityHashMap());
    }

    private RegistryReadOps(DynamicOps<T> var0, RegistryResourceAccess var1, IRegistryCustom var2, IdentityHashMap<ResourceKey<? extends IRegistry<?>>, a<?>> var3) {
        super(var0);
        this.resources = var1;
        this.registryAccess = var2;
        this.readCache = var3;
        this.jsonOps = var0 == JsonOps.INSTANCE ? this : new RegistryReadOps<T>(JsonOps.INSTANCE, var1, var2, (IdentityHashMap<ResourceKey<IRegistry<?>>, a<?>>)var3);
    }

    protected <E> DataResult<Pair<Supplier<E>, T>> decodeElement(T var0, ResourceKey<? extends IRegistry<E>> var12, Codec<E> var2, boolean var3) {
        Optional var4 = this.registryAccess.ownedRegistry(var12);
        if (!var4.isPresent()) {
            return DataResult.error((String)("Unknown registry: " + var12));
        }
        IRegistryWritable var5 = var4.get();
        DataResult var6 = MinecraftKey.CODEC.decode(this.delegate, var0);
        if (!var6.result().isPresent()) {
            if (!var3) {
                return DataResult.error((String)"Inline definitions not allowed here");
            }
            return var2.decode((DynamicOps)this, var0).map(var02 -> var02.mapFirst(var0 -> () -> var0));
        }
        Pair var7 = (Pair)var6.result().get();
        ResourceKey var8 = ResourceKey.create(var12, (MinecraftKey)var7.getFirst());
        return this.readAndRegisterElement(var12, var5, var2, var8).map(var1 -> Pair.of((Object)var1, (Object)var7.getSecond()));
    }

    public <E> DataResult<RegistryMaterials<E>> decodeElements(RegistryMaterials<E> var0, ResourceKey<? extends IRegistry<E>> var1, Codec<E> var2) {
        Collection var32 = this.resources.listResources(var1);
        DataResult var4 = DataResult.success(var0, (Lifecycle)Lifecycle.stable());
        for (ResourceKey var6 : var32) {
            var4 = var4.flatMap(var3 -> this.readAndRegisterElement(var1, (IRegistryWritable)var3, var2, var6).map(var1 -> var3));
        }
        return var4.setPartial(var0);
    }

    private <E> DataResult<Supplier<E>> readAndRegisterElement(ResourceKey<? extends IRegistry<E>> var0, IRegistryWritable<E> var1, Codec<E> var22, ResourceKey<E> var3) {
        DataResult var7;
        a<E> var4 = this.readCache(var0);
        DataResult var5 = var4.values.get(var3);
        if (var5 != null) {
            return var5;
        }
        var4.values.put(var3, DataResult.success(RegistryReadOps.createPlaceholderGetter(var1, var3)));
        Optional<DataResult<RegistryResourceAccess.ParsedEntry<E>>> var6 = this.resources.parseElement((DynamicOps<JsonElement>)this.jsonOps, var0, var3, var22);
        if (var6.isEmpty()) {
            var7 = var1.containsKey(var3) ? DataResult.success(RegistryReadOps.createRegistryGetter(var1, var3), (Lifecycle)Lifecycle.stable()) : DataResult.error((String)("Missing referenced custom/removed registry entry for registry " + var0 + " named " + var3.location()));
        } else {
            DataResult<RegistryResourceAccess.ParsedEntry<E>> var8 = var6.get();
            Optional var9 = var8.result();
            if (var9.isPresent()) {
                RegistryResourceAccess.ParsedEntry var10 = (RegistryResourceAccess.ParsedEntry)var9.get();
                var1.registerOrOverride(var10.fixedId(), var3, var10.value(), var8.lifecycle());
            }
            var7 = var8.map(var2 -> RegistryReadOps.createRegistryGetter(var1, var3));
        }
        var4.values.put(var3, var7);
        return var7;
    }

    private static <E> Supplier<E> createPlaceholderGetter(IRegistryWritable<E> var0, ResourceKey<E> var1) {
        return Suppliers.memoize(() -> {
            Object var2 = var0.get(var1);
            if (var2 == null) {
                throw new RuntimeException("Error during recursive registry parsing, element resolved too early: " + var1);
            }
            return var2;
        });
    }

    private static <E> Supplier<E> createRegistryGetter(final IRegistry<E> var0, final ResourceKey<E> var1) {
        return new Supplier<E>(){

            @Override
            public E get() {
                return var0.get(var1);
            }

            public String toString() {
                return var1.toString();
            }
        };
    }

    private <E> a<E> readCache(ResourceKey<? extends IRegistry<E>> var02) {
        return this.readCache.computeIfAbsent(var02, var0 -> new a());
    }

    protected <E> DataResult<IRegistry<E>> registry(ResourceKey<? extends IRegistry<E>> var02) {
        return this.registryAccess.ownedRegistry(var02).map(var0 -> DataResult.success((Object)var0, (Lifecycle)var0.elementsLifecycle())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + var02)));
    }

    static final class a<E> {
        final Map<ResourceKey<E>, DataResult<Supplier<E>>> values = Maps.newIdentityHashMap();

        a() {
        }
    }
}

