/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;

public class PacketPlayOutTileEntityData
implements Packet<PacketListenerPlayOut> {
    private final BlockPosition pos;
    private final TileEntityTypes<?> type;
    @Nullable
    private final NBTTagCompound tag;

    public static PacketPlayOutTileEntityData create(TileEntity var0, Function<TileEntity, NBTTagCompound> var1) {
        return new PacketPlayOutTileEntityData(var0.getBlockPos(), var0.getType(), var1.apply(var0));
    }

    public static PacketPlayOutTileEntityData create(TileEntity var0) {
        return PacketPlayOutTileEntityData.create(var0, TileEntity::getUpdateTag);
    }

    private PacketPlayOutTileEntityData(BlockPosition var0, TileEntityTypes<?> var1, NBTTagCompound var2) {
        this.pos = var0;
        this.type = var1;
        this.tag = var2.isEmpty() ? null : var2;
    }

    public PacketPlayOutTileEntityData(PacketDataSerializer var0) {
        this.pos = var0.readBlockPos();
        this.type = (TileEntityTypes)IRegistry.BLOCK_ENTITY_TYPE.byId(var0.readVarInt());
        this.tag = var0.readNbt();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeBlockPos(this.pos);
        var0.writeVarInt(IRegistry.BLOCK_ENTITY_TYPE.getId(this.type));
        var0.writeNbt(this.tag);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleBlockEntityData(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public TileEntityTypes<?> getType() {
        return this.type;
    }

    @Nullable
    public NBTTagCompound getTag() {
        return this.tag;
    }
}

