/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticWrapper;

public class PacketPlayOutStatistic
implements Packet<PacketListenerPlayOut> {
    private final Object2IntMap<Statistic<?>> stats;

    public PacketPlayOutStatistic(Object2IntMap<Statistic<?>> var0) {
        this.stats = var0;
    }

    public PacketPlayOutStatistic(PacketDataSerializer var02) {
        this.stats = (Object2IntMap)var02.readMap(Object2IntOpenHashMap::new, var0 -> {
            int var1 = var0.readVarInt();
            int var2 = var0.readVarInt();
            return PacketPlayOutStatistic.readStatCap((StatisticWrapper)IRegistry.STAT_TYPE.byId(var1), var2);
        }, PacketDataSerializer::readVarInt);
    }

    private static <T> Statistic<T> readStatCap(StatisticWrapper<T> var0, int var1) {
        return var0.get(var0.getRegistry().byId(var1));
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAwardStats(this);
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeMap(this.stats, (var0, var1) -> {
            var0.writeVarInt(IRegistry.STAT_TYPE.getId(var1.getType()));
            var0.writeVarInt(this.getStatIdCap((Statistic)var1));
        }, PacketDataSerializer::writeVarInt);
    }

    private <T> int getStatIdCap(Statistic<T> var0) {
        return var0.getType().getRegistry().getId(var0.getValue());
    }

    public Map<Statistic<?>, Integer> getStats() {
        return this.stats;
    }
}

