/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutSpawnEntityLiving
implements Packet<PacketListenerPlayOut> {
    private final int id;
    private final UUID uuid;
    private final int type;
    private final double x;
    private final double y;
    private final double z;
    private final int xd;
    private final int yd;
    private final int zd;
    private final byte yRot;
    private final byte xRot;
    private final byte yHeadRot;

    public PacketPlayOutSpawnEntityLiving(EntityLiving var0) {
        this.id = var0.getId();
        this.uuid = var0.getUUID();
        this.type = IRegistry.ENTITY_TYPE.getId(var0.getType());
        this.x = var0.getX();
        this.y = var0.getY();
        this.z = var0.getZ();
        this.yRot = (byte)(var0.getYRot() * 256.0f / 360.0f);
        this.xRot = (byte)(var0.getXRot() * 256.0f / 360.0f);
        this.yHeadRot = (byte)(var0.yHeadRot * 256.0f / 360.0f);
        double var1 = 3.9;
        Vec3D var3 = var0.getDeltaMovement();
        double var4 = MathHelper.clamp(var3.x, -3.9, 3.9);
        double var6 = MathHelper.clamp(var3.y, -3.9, 3.9);
        double var8 = MathHelper.clamp(var3.z, -3.9, 3.9);
        this.xd = (int)(var4 * 8000.0);
        this.yd = (int)(var6 * 8000.0);
        this.zd = (int)(var8 * 8000.0);
    }

    public PacketPlayOutSpawnEntityLiving(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.uuid = var0.readUUID();
        this.type = var0.readVarInt();
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.yRot = var0.readByte();
        this.xRot = var0.readByte();
        this.yHeadRot = var0.readByte();
        this.xd = var0.readShort();
        this.yd = var0.readShort();
        this.zd = var0.readShort();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeUUID(this.uuid);
        var0.writeVarInt(this.type);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeByte(this.yRot);
        var0.writeByte(this.xRot);
        var0.writeByte(this.yHeadRot);
        var0.writeShort(this.xd);
        var0.writeShort(this.yd);
        var0.writeShort(this.zd);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAddMob(this);
    }

    public int getId() {
        return this.id;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getType() {
        return this.type;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getXd() {
        return this.xd;
    }

    public int getYd() {
        return this.yd;
    }

    public int getZd() {
        return this.zd;
    }

    public byte getyRot() {
        return this.yRot;
    }

    public byte getxRot() {
        return this.xRot;
    }

    public byte getyHeadRot() {
        return this.yHeadRot;
    }
}

