/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.Entity;

public class PacketPlayOutEntityTeleport
implements Packet<PacketListenerPlayOut> {
    private final int id;
    private final double x;
    private final double y;
    private final double z;
    private final byte yRot;
    private final byte xRot;
    private final boolean onGround;

    public PacketPlayOutEntityTeleport(Entity var0) {
        this.id = var0.getId();
        this.x = var0.getX();
        this.y = var0.getY();
        this.z = var0.getZ();
        this.yRot = (byte)(var0.getYRot() * 256.0f / 360.0f);
        this.xRot = (byte)(var0.getXRot() * 256.0f / 360.0f);
        this.onGround = var0.isOnGround();
    }

    public PacketPlayOutEntityTeleport(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.yRot = var0.readByte();
        this.xRot = var0.readByte();
        this.onGround = var0.readBoolean();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeByte(this.yRot);
        var0.writeByte(this.xRot);
        var0.writeBoolean(this.onGround);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleTeleportEntity(this);
    }

    public int getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public byte getyRot() {
        return this.yRot;
    }

    public byte getxRot() {
        return this.xRot;
    }

    public boolean isOnGround() {
        return this.onGround;
    }
}

