/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.syncher.DataWatcher;

public class PacketPlayOutEntityMetadata
implements Packet<PacketListenerPlayOut> {
    private final int id;
    @Nullable
    private final List<DataWatcher.Item<?>> packedItems;

    public PacketPlayOutEntityMetadata(int var0, DataWatcher var1, boolean var2) {
        this.id = var0;
        if (var2) {
            this.packedItems = var1.getAll();
            var1.clearDirty();
        } else {
            this.packedItems = var1.packDirty();
        }
    }

    public PacketPlayOutEntityMetadata(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.packedItems = DataWatcher.unpack(var0);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        DataWatcher.pack(this.packedItems, var0);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetEntityData(this);
    }

    @Nullable
    public List<DataWatcher.Item<?>> getUnpackedData() {
        return this.packedItems;
    }

    public int getId() {
        return this.id;
    }
}

