/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public abstract class PacketPlayOutEntity
implements Packet<PacketListenerPlayOut> {
    private static final double TRUNCATION_STEPS = 4096.0;
    protected final int entityId;
    protected final short xa;
    protected final short ya;
    protected final short za;
    protected final byte yRot;
    protected final byte xRot;
    protected final boolean onGround;
    protected final boolean hasRot;
    protected final boolean hasPos;

    public static long entityToPacket(double var0) {
        return MathHelper.lfloor(var0 * 4096.0);
    }

    public static double packetToEntity(long var0) {
        return (double)var0 / 4096.0;
    }

    public Vec3D updateEntityPosition(Vec3D var0) {
        double var1 = this.xa == 0 ? var0.x : PacketPlayOutEntity.packetToEntity(PacketPlayOutEntity.entityToPacket(var0.x) + (long)this.xa);
        double var3 = this.ya == 0 ? var0.y : PacketPlayOutEntity.packetToEntity(PacketPlayOutEntity.entityToPacket(var0.y) + (long)this.ya);
        double var5 = this.za == 0 ? var0.z : PacketPlayOutEntity.packetToEntity(PacketPlayOutEntity.entityToPacket(var0.z) + (long)this.za);
        return new Vec3D(var1, var3, var5);
    }

    public static Vec3D packetToEntity(long var0, long var2, long var4) {
        return new Vec3D(var0, var2, var4).scale(2.44140625E-4);
    }

    protected PacketPlayOutEntity(int var0, short var1, short var2, short var3, byte var4, byte var5, boolean var6, boolean var7, boolean var8) {
        this.entityId = var0;
        this.xa = var1;
        this.ya = var2;
        this.za = var3;
        this.yRot = var4;
        this.xRot = var5;
        this.onGround = var6;
        this.hasRot = var7;
        this.hasPos = var8;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleMoveEntity(this);
    }

    public String toString() {
        return "Entity_" + super.toString();
    }

    @Nullable
    public Entity getEntity(World var0) {
        return var0.getEntity(this.entityId);
    }

    public short getXa() {
        return this.xa;
    }

    public short getYa() {
        return this.ya;
    }

    public short getZa() {
        return this.za;
    }

    public byte getyRot() {
        return this.yRot;
    }

    public byte getxRot() {
        return this.xRot;
    }

    public boolean hasRotation() {
        return this.hasRot;
    }

    public boolean hasPosition() {
        return this.hasPos;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public static class PacketPlayOutEntityLook
    extends PacketPlayOutEntity {
        public PacketPlayOutEntityLook(int var0, byte var1, byte var2, boolean var3) {
            super(var0, (short)0, (short)0, (short)0, var1, var2, var3, true, false);
        }

        public static PacketPlayOutEntityLook read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            byte var2 = var0.readByte();
            byte var3 = var0.readByte();
            boolean var4 = var0.readBoolean();
            return new PacketPlayOutEntityLook(var1, var2, var3, var4);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeVarInt(this.entityId);
            var0.writeByte(this.yRot);
            var0.writeByte(this.xRot);
            var0.writeBoolean(this.onGround);
        }
    }

    public static class PacketPlayOutRelEntityMove
    extends PacketPlayOutEntity {
        public PacketPlayOutRelEntityMove(int var0, short var1, short var2, short var3, boolean var4) {
            super(var0, var1, var2, var3, (byte)0, (byte)0, var4, false, true);
        }

        public static PacketPlayOutRelEntityMove read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            short var2 = var0.readShort();
            short var3 = var0.readShort();
            short var4 = var0.readShort();
            boolean var5 = var0.readBoolean();
            return new PacketPlayOutRelEntityMove(var1, var2, var3, var4, var5);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeVarInt(this.entityId);
            var0.writeShort(this.xa);
            var0.writeShort(this.ya);
            var0.writeShort(this.za);
            var0.writeBoolean(this.onGround);
        }
    }

    public static class PacketPlayOutRelEntityMoveLook
    extends PacketPlayOutEntity {
        public PacketPlayOutRelEntityMoveLook(int var0, short var1, short var2, short var3, byte var4, byte var5, boolean var6) {
            super(var0, var1, var2, var3, var4, var5, var6, true, true);
        }

        public static PacketPlayOutRelEntityMoveLook read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            short var2 = var0.readShort();
            short var3 = var0.readShort();
            short var4 = var0.readShort();
            byte var5 = var0.readByte();
            byte var6 = var0.readByte();
            boolean var7 = var0.readBoolean();
            return new PacketPlayOutRelEntityMoveLook(var1, var2, var3, var4, var5, var6, var7);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeVarInt(this.entityId);
            var0.writeShort(this.xa);
            var0.writeShort(this.ya);
            var0.writeShort(this.za);
            var0.writeByte(this.yRot);
            var0.writeByte(this.xRot);
            var0.writeBoolean(this.onGround);
        }
    }
}

