/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.ExpirableMemory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.PathEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketDebug {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void sendGameTestAddMarker(WorldServer var0, BlockPosition var1, String var2, int var3, int var4) {
        PacketDataSerializer var5 = new PacketDataSerializer(Unpooled.buffer());
        var5.writeBlockPos(var1);
        var5.writeInt(var3);
        var5.writeUtf(var2);
        var5.writeInt(var4);
        PacketDebug.sendPacketToAllPlayers(var0, var5, PacketPlayOutCustomPayload.DEBUG_GAME_TEST_ADD_MARKER);
    }

    public static void sendGameTestClearPacket(WorldServer var0) {
        PacketDataSerializer var1 = new PacketDataSerializer(Unpooled.buffer());
        PacketDebug.sendPacketToAllPlayers(var0, var1, PacketPlayOutCustomPayload.DEBUG_GAME_TEST_CLEAR);
    }

    public static void sendPoiPacketsForChunk(WorldServer var0, ChunkCoordIntPair var1) {
    }

    public static void sendPoiAddedPacket(WorldServer var0, BlockPosition var1) {
        PacketDebug.sendVillageSectionsPacket(var0, var1);
    }

    public static void sendPoiRemovedPacket(WorldServer var0, BlockPosition var1) {
        PacketDebug.sendVillageSectionsPacket(var0, var1);
    }

    public static void sendPoiTicketCountPacket(WorldServer var0, BlockPosition var1) {
        PacketDebug.sendVillageSectionsPacket(var0, var1);
    }

    private static void sendVillageSectionsPacket(WorldServer var0, BlockPosition var1) {
    }

    public static void sendPathFindingPacket(World var0, EntityInsentient var1, @Nullable PathEntity var2, float var3) {
    }

    public static void sendNeighborsUpdatePacket(World var0, BlockPosition var1) {
    }

    public static void sendStructurePacket(GeneratorAccessSeed var0, StructureStart<?> var1) {
    }

    public static void sendGoalSelector(World var0, EntityInsentient var1, PathfinderGoalSelector var2) {
        if (!(var0 instanceof WorldServer)) {
            return;
        }
    }

    public static void sendRaids(WorldServer var0, Collection<Raid> var1) {
    }

    public static void sendEntityBrain(EntityLiving var0) {
    }

    public static void sendBeeInfo(EntityBee var0) {
    }

    public static void sendGameEventInfo(World var0, GameEvent var1, BlockPosition var2) {
    }

    public static void sendGameEventListenerInfo(World var0, GameEventListener var1) {
    }

    public static void sendHiveInfo(World var0, BlockPosition var1, IBlockData var2, TileEntityBeehive var3) {
    }

    private static void writeBrain(EntityLiving var02, PacketDataSerializer var12) {
        Object var6;
        Object var5;
        BehaviorController<PathEntity> var2 = var02.getBrain();
        long var3 = var02.level.getGameTime();
        if (var02 instanceof InventoryCarrier) {
            var5 = ((InventoryCarrier)((Object)var02)).getInventory();
            var12.writeUtf(var5.isEmpty() ? "" : var5.toString());
        } else {
            var12.writeUtf("");
        }
        if (var2.hasMemoryValue(MemoryModuleType.PATH)) {
            var12.writeBoolean(true);
            var5 = var2.getMemory(MemoryModuleType.PATH).get();
            ((PathEntity)var5).writeToStream(var12);
        } else {
            var12.writeBoolean(false);
        }
        if (var02 instanceof EntityVillager) {
            var6 = (EntityVillager)var02;
            boolean var7 = ((EntityVillager)var6).wantsToSpawnGolem(var3);
            var12.writeBoolean(var7);
        } else {
            var12.writeBoolean(false);
        }
        var12.writeCollection(var2.getActiveActivities(), (var0, var1) -> var0.writeUtf(var1.getName()));
        var6 = var2.getRunningBehaviors().stream().map(Behavior::toString).collect(Collectors.toSet());
        var12.writeCollection(var6, PacketDataSerializer::writeUtf);
        var12.writeCollection(PacketDebug.getMemoryDescriptions(var02, var3), (var0, var1) -> {
            String var2 = UtilColor.truncateStringIfNecessary(var1, 255, true);
            var0.writeUtf(var2);
        });
        if (var02 instanceof EntityVillager) {
            Set var7 = Stream.of(MemoryModuleType.JOB_SITE, MemoryModuleType.HOME, MemoryModuleType.MEETING_POINT).map(var2::getMemory).flatMap(SystemUtils::toStream).map(GlobalPos::pos).collect(Collectors.toSet());
            var12.writeCollection(var7, PacketDataSerializer::writeBlockPos);
        } else {
            var12.writeVarInt(0);
        }
        if (var02 instanceof EntityVillager) {
            Set var7 = Stream.of(MemoryModuleType.POTENTIAL_JOB_SITE).map(var2::getMemory).flatMap(SystemUtils::toStream).map(GlobalPos::pos).collect(Collectors.toSet());
            var12.writeCollection(var7, PacketDataSerializer::writeBlockPos);
        } else {
            var12.writeVarInt(0);
        }
        if (var02 instanceof EntityVillager) {
            Map<UUID, Object2IntMap<ReputationType>> var7 = ((EntityVillager)var02).getGossips().getGossipEntries();
            ArrayList var8 = Lists.newArrayList();
            var7.forEach((var1, var22) -> {
                String var32 = DebugEntityNameGenerator.getEntityName(var1);
                var22.forEach((var2, var3) -> var8.add(var32 + ": " + var2 + ": " + var3));
            });
            var12.writeCollection(var8, PacketDataSerializer::writeUtf);
        } else {
            var12.writeVarInt(0);
        }
    }

    private static List<String> getMemoryDescriptions(EntityLiving var0, long var1) {
        Map<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> var3 = var0.getBrain().getMemories();
        ArrayList var4 = Lists.newArrayList();
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> var6 : var3.entrySet()) {
            Object var9;
            MemoryModuleType<?> var7 = var6.getKey();
            Optional<ExpirableMemory<?>> var8 = var6.getValue();
            if (var8.isPresent()) {
                ExpirableMemory<?> var10 = var8.get();
                Object var11 = var10.getValue();
                if (var7 == MemoryModuleType.HEARD_BELL_TIME) {
                    long var12 = var1 - (Long)var11;
                    var9 = var12 + " ticks ago";
                } else {
                    var9 = var10.canExpire() ? PacketDebug.getShortDescription((WorldServer)var0.level, var11) + " (ttl: " + var10.getTimeToLive() + ")" : PacketDebug.getShortDescription((WorldServer)var0.level, var11);
                }
            } else {
                var9 = "-";
            }
            var4.add(IRegistry.MEMORY_MODULE_TYPE.getKey(var7).getPath() + ": " + (String)var9);
        }
        var4.sort(String::compareTo);
        return var4;
    }

    private static String getShortDescription(WorldServer var0, @Nullable Object var1) {
        if (var1 == null) {
            return "-";
        }
        if (var1 instanceof UUID) {
            return PacketDebug.getShortDescription(var0, var0.getEntity((UUID)var1));
        }
        if (var1 instanceof EntityLiving) {
            Entity var2 = (Entity)var1;
            return DebugEntityNameGenerator.getEntityName(var2);
        }
        if (var1 instanceof INamableTileEntity) {
            return ((INamableTileEntity)var1).getName().getString();
        }
        if (var1 instanceof MemoryTarget) {
            return PacketDebug.getShortDescription(var0, ((MemoryTarget)var1).getTarget());
        }
        if (var1 instanceof BehaviorPositionEntity) {
            return PacketDebug.getShortDescription(var0, ((BehaviorPositionEntity)var1).getEntity());
        }
        if (var1 instanceof GlobalPos) {
            return PacketDebug.getShortDescription(var0, ((GlobalPos)var1).pos());
        }
        if (var1 instanceof BehaviorTarget) {
            return PacketDebug.getShortDescription(var0, ((BehaviorTarget)var1).currentBlockPosition());
        }
        if (var1 instanceof EntityDamageSource) {
            Entity var2 = ((EntityDamageSource)var1).getEntity();
            return var2 == null ? var1.toString() : PacketDebug.getShortDescription(var0, var2);
        }
        if (var1 instanceof Collection) {
            ArrayList var2 = Lists.newArrayList();
            for (Object var4 : (Iterable)var1) {
                var2.add(PacketDebug.getShortDescription(var0, var4));
            }
            return ((Object)var2).toString();
        }
        return var1.toString();
    }

    private static void sendPacketToAllPlayers(WorldServer var0, PacketDataSerializer var1, MinecraftKey var2) {
        PacketPlayOutCustomPayload var3 = new PacketPlayOutCustomPayload(var2, var1);
        for (EntityHuman entityHuman : var0.getLevel().players()) {
            ((EntityPlayer)entityHuman).connection.send(var3);
        }
    }

    private static /* synthetic */ void a(PacketDataSerializer var0, Raid var1) {
        var0.writeBlockPos(var1.getCenter());
    }

    private static /* synthetic */ void a(PacketDataSerializer var0, PathfinderGoalWrapped var1) {
        var0.writeInt(var1.getPriority());
        var0.writeBoolean(var1.isRunning());
        var0.writeUtf(var1.getGoal().getClass().getSimpleName());
    }

    private static /* synthetic */ void a(WorldServer var0, VillagePlaceRecord var1) {
        PacketDebug.sendPoiAddedPacket(var0, var1.getPos());
    }

    private static /* synthetic */ boolean a(VillagePlaceType var0) {
        return true;
    }
}

