/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.FormattedString;

public abstract class ChatBaseComponent
implements IChatMutableComponent {
    protected final List<IChatBaseComponent> siblings = Lists.newArrayList();
    private FormattedString visualOrderText = FormattedString.EMPTY;
    @Nullable
    private LocaleLanguage decomposedWith;
    private ChatModifier style = ChatModifier.EMPTY;

    @Override
    public IChatMutableComponent append(IChatBaseComponent var0) {
        this.siblings.add(var0);
        return this;
    }

    @Override
    public String getContents() {
        return "";
    }

    @Override
    public List<IChatBaseComponent> getSiblings() {
        return this.siblings;
    }

    @Override
    public IChatMutableComponent setStyle(ChatModifier var0) {
        this.style = var0;
        return this;
    }

    @Override
    public ChatModifier getStyle() {
        return this.style;
    }

    @Override
    public abstract ChatBaseComponent plainCopy();

    @Override
    public final IChatMutableComponent copy() {
        ChatBaseComponent var0 = this.plainCopy();
        var0.siblings.addAll(this.siblings);
        var0.setStyle(this.style);
        return var0;
    }

    @Override
    public FormattedString getVisualOrderText() {
        LocaleLanguage var0 = LocaleLanguage.getInstance();
        if (this.decomposedWith != var0) {
            this.visualOrderText = var0.getVisualOrder(this);
            this.decomposedWith = var0;
        }
        return this.visualOrderText;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChatBaseComponent) {
            ChatBaseComponent var1 = (ChatBaseComponent)var0;
            return this.siblings.equals(var1.siblings) && Objects.equals(this.getStyle(), var1.getStyle());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getStyle(), this.siblings);
    }

    public String toString() {
        return "BaseComponent{style=" + this.style + ", siblings=" + this.siblings + "}";
    }

    @Override
    public /* synthetic */ IChatMutableComponent plainCopy() {
        return this.plainCopy();
    }
}

