/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.features;

import java.util.List;
import java.util.Random;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.features.PileFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class FeatureUtils {
    public static WorldGenFeatureConfigured<?, ?> bootstrap() {
        WorldGenFeatureConfigured[] var0 = new WorldGenFeatureConfigured[]{AquaticFeatures.KELP, CaveFeatures.MOSS_PATCH_BONEMEAL, EndFeatures.CHORUS_PLANT, MiscOverworldFeatures.SPRING_LAVA_OVERWORLD, NetherFeatures.BASALT_BLOBS, OreFeatures.ORE_ANCIENT_DEBRIS_LARGE, PileFeatures.PILE_HAY, TreeFeatures.AZALEA_TREE, VegetationFeatures.TREES_OLD_GROWTH_PINE_TAIGA};
        return SystemUtils.getRandom(var0, new Random());
    }

    private static BlockPredicate simplePatchPredicate(List<Block> var0) {
        BlockPredicate var1 = !var0.isEmpty() ? BlockPredicate.allOf(BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.matchesBlocks(var0, new BlockPosition(0, -1, 0))) : BlockPredicate.ONLY_IN_AIR_PREDICATE;
        return var1;
    }

    public static WorldGenFeatureRandomPatchConfiguration simpleRandomPatchConfiguration(int var0, PlacedFeature var1) {
        return new WorldGenFeatureRandomPatchConfiguration(var0, 7, 3, () -> var1);
    }

    public static WorldGenFeatureRandomPatchConfiguration simplePatchConfiguration(WorldGenFeatureConfigured<?, ?> var0, List<Block> var1, int var2) {
        return FeatureUtils.simpleRandomPatchConfiguration(var2, var0.filtered(FeatureUtils.simplePatchPredicate(var1)));
    }

    public static WorldGenFeatureRandomPatchConfiguration simplePatchConfiguration(WorldGenFeatureConfigured<?, ?> var0, List<Block> var1) {
        return FeatureUtils.simplePatchConfiguration(var0, var1, 96);
    }

    public static WorldGenFeatureRandomPatchConfiguration simplePatchConfiguration(WorldGenFeatureConfigured<?, ?> var0) {
        return FeatureUtils.simplePatchConfiguration(var0, List.of(), 96);
    }

    public static <FC extends WorldGenFeatureConfiguration> WorldGenFeatureConfigured<FC, ?> register(String var0, WorldGenFeatureConfigured<FC, ?> var1) {
        return IRegistry.register(RegistryGeneration.CONFIGURED_FEATURE, var0, var1);
    }
}

