/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationPath;

public class VibrationParticleOption
implements ParticleParam {
    public static final Codec<VibrationParticleOption> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)VibrationPath.CODEC.fieldOf("vibration").forGetter(var0 -> var0.vibrationPath)).apply((Applicative)var02, VibrationParticleOption::new));
    public static final ParticleParam.a<VibrationParticleOption> DESERIALIZER = new ParticleParam.a<VibrationParticleOption>(){

        @Override
        public VibrationParticleOption fromCommand(Particle<VibrationParticleOption> var0, StringReader var1) throws CommandSyntaxException {
            var1.expect(' ');
            float var2 = (float)var1.readDouble();
            var1.expect(' ');
            float var3 = (float)var1.readDouble();
            var1.expect(' ');
            float var4 = (float)var1.readDouble();
            var1.expect(' ');
            float var5 = (float)var1.readDouble();
            var1.expect(' ');
            float var6 = (float)var1.readDouble();
            var1.expect(' ');
            float var7 = (float)var1.readDouble();
            var1.expect(' ');
            int var8 = var1.readInt();
            BlockPosition var9 = new BlockPosition(var2, var3, var4);
            BlockPosition var10 = new BlockPosition(var5, var6, var7);
            return new VibrationParticleOption(new VibrationPath(var9, new BlockPositionSource(var10), var8));
        }

        @Override
        public VibrationParticleOption fromNetwork(Particle<VibrationParticleOption> var0, PacketDataSerializer var1) {
            VibrationPath var2 = VibrationPath.read(var1);
            return new VibrationParticleOption(var2);
        }

        @Override
        public /* synthetic */ ParticleParam fromNetwork(Particle particle, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(particle, packetDataSerializer);
        }

        @Override
        public /* synthetic */ ParticleParam fromCommand(Particle particle, StringReader stringReader) throws CommandSyntaxException {
            return this.fromCommand(particle, stringReader);
        }
    };
    private final VibrationPath vibrationPath;

    public VibrationParticleOption(VibrationPath var0) {
        this.vibrationPath = var0;
    }

    @Override
    public void writeToNetwork(PacketDataSerializer var0) {
        VibrationPath.write(var0, this.vibrationPath);
    }

    @Override
    public String writeToString() {
        BlockPosition var0 = this.vibrationPath.getOrigin();
        double var1 = var0.getX();
        double var3 = var0.getY();
        double var5 = var0.getZ();
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %d", IRegistry.PARTICLE_TYPE.getKey(this.getType()), var1, var3, var5, var1, var3, var5, this.vibrationPath.getArrivalInTicks());
    }

    public Particle<VibrationParticleOption> getType() {
        return Particles.VIBRATION;
    }

    public VibrationPath getVibrationPath() {
        return this.vibrationPath;
    }
}

