/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArgumentPredicateItemStack
implements Predicate<ItemStack> {
    private static final Dynamic2CommandExceptionType ERROR_STACK_TOO_BIG = new Dynamic2CommandExceptionType((var0, var1) -> new ChatMessage("arguments.item.overstacked", var0, var1));
    private final Item item;
    @Nullable
    private final NBTTagCompound tag;

    public ArgumentPredicateItemStack(Item var0, @Nullable NBTTagCompound var1) {
        this.item = var0;
        this.tag = var1;
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    public boolean test(ItemStack var0) {
        return var0.is(this.item) && GameProfileSerializer.compareNbt(this.tag, var0.getTag(), true);
    }

    public ItemStack createItemStack(int var0, boolean var1) throws CommandSyntaxException {
        ItemStack var2 = new ItemStack(this.item, var0);
        if (this.tag != null) {
            var2.setTag(this.tag);
        }
        if (var1 && var0 > var2.getMaxStackSize()) {
            throw ERROR_STACK_TOO_BIG.create((Object)IRegistry.ITEM.getKey(this.item), (Object)var2.getMaxStackSize());
        }
        return var2;
    }

    public String serialize() {
        StringBuilder var0 = new StringBuilder(IRegistry.ITEM.getId(this.item));
        if (this.tag != null) {
            var0.append(this.tag);
        }
        return var0.toString();
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((ItemStack)object);
    }
}

