/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class ArgumentVec2
implements ArgumentType<IVectorPosition> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0", "~ ~", "0.1 -0.5", "~1 ~-2");
    public static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)new ChatMessage("argument.pos2d.incomplete"));
    private final boolean centerCorrect;

    public ArgumentVec2(boolean var0) {
        this.centerCorrect = var0;
    }

    public static ArgumentVec2 vec2() {
        return new ArgumentVec2(true);
    }

    public static ArgumentVec2 vec2(boolean var0) {
        return new ArgumentVec2(var0);
    }

    public static Vec2F getVec2(CommandContext<CommandListenerWrapper> var0, String var1) {
        Vec3D var2 = ((IVectorPosition)var0.getArgument(var1, IVectorPosition.class)).getPosition((CommandListenerWrapper)var0.getSource());
        return new Vec2F((float)var2.x, (float)var2.z);
    }

    public IVectorPosition parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        if (!var0.canRead()) {
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        ArgumentParserPosition var2 = ArgumentParserPosition.parseDouble(var0, this.centerCorrect);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        ArgumentParserPosition var3 = ArgumentParserPosition.parseDouble(var0, this.centerCorrect);
        return new VectorPosition(var2, new ArgumentParserPosition(true, 0.0), var3);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        if (var0.getSource() instanceof ICompletionProvider) {
            String var2 = var1.getRemaining();
            Collection<ICompletionProvider.a> var3 = !var2.isEmpty() && var2.charAt(0) == '^' ? Collections.singleton(ICompletionProvider.a.DEFAULT_LOCAL) : ((ICompletionProvider)var0.getSource()).getAbsoluteCoordinates();
            return ICompletionProvider.suggest2DCoordinates(var2, var3, var1, CommandDispatcher.createValidator(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

