/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.world.entity.Entity;

public class ArgumentScoreholder
implements ArgumentType<a> {
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_SCORE_HOLDERS = (var0, var12) -> {
        StringReader var2 = new StringReader(var12.getInput());
        var2.setCursor(var12.getStart());
        ArgumentParserSelector var3 = new ArgumentParserSelector(var2);
        try {
            var3.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var3.fillSuggestions(var12, var1 -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getOnlinePlayerNames(), var1));
    };
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType ERROR_NO_RESULTS = new SimpleCommandExceptionType((Message)new ChatMessage("argument.scoreHolder.empty"));
    private static final byte FLAG_MULTIPLE = 1;
    final boolean multiple;

    public ArgumentScoreholder(boolean var0) {
        this.multiple = var0;
    }

    public static String getName(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ArgumentScoreholder.getNames(var0, var1).iterator().next();
    }

    public static Collection<String> getNames(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ArgumentScoreholder.getNames(var0, var1, Collections::emptyList);
    }

    public static Collection<String> getNamesWithDefaultWildcard(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ArgumentScoreholder.getNames(var0, var1, ((CommandListenerWrapper)var0.getSource()).getServer().getScoreboard()::getTrackedPlayers);
    }

    public static Collection<String> getNames(CommandContext<CommandListenerWrapper> var0, String var1, Supplier<Collection<String>> var2) throws CommandSyntaxException {
        Collection<String> var3 = ((a)var0.getArgument(var1, a.class)).getNames((CommandListenerWrapper)var0.getSource(), var2);
        if (var3.isEmpty()) {
            throw ArgumentEntity.NO_ENTITIES_FOUND.create();
        }
        return var3;
    }

    public static ArgumentScoreholder scoreHolder() {
        return new ArgumentScoreholder(false);
    }

    public static ArgumentScoreholder scoreHolders() {
        return new ArgumentScoreholder(true);
    }

    public a parse(StringReader var02) throws CommandSyntaxException {
        if (var02.canRead() && var02.peek() == '@') {
            ArgumentParserSelector var12 = new ArgumentParserSelector(var02);
            EntitySelector var22 = var12.parse();
            if (!this.multiple && var22.getMaxResults() > 1) {
                throw ArgumentEntity.ERROR_NOT_SINGLE_ENTITY.create();
            }
            return new b(var22);
        }
        int var13 = var02.getCursor();
        while (var02.canRead() && var02.peek() != ' ') {
            var02.skip();
        }
        String var23 = var02.getString().substring(var13, var02.getCursor());
        if (var23.equals("*")) {
            return (var0, var1) -> {
                Collection var2 = (Collection)var1.get();
                if (var2.isEmpty()) {
                    throw ERROR_NO_RESULTS.create();
                }
                return var2;
            };
        }
        Set<String> var3 = Collections.singleton(var23);
        return (var1, var2) -> var3;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    @FunctionalInterface
    public static interface a {
        public Collection<String> getNames(CommandListenerWrapper var1, Supplier<Collection<String>> var2) throws CommandSyntaxException;
    }

    public static class b
    implements a {
        private final EntitySelector selector;

        public b(EntitySelector var0) {
            this.selector = var0;
        }

        @Override
        public Collection<String> getNames(CommandListenerWrapper var0, Supplier<Collection<String>> var1) throws CommandSyntaxException {
            List<? extends Entity> var2 = this.selector.findEntities(var0);
            if (var2.isEmpty()) {
                throw ArgumentEntity.NO_ENTITIES_FOUND.create();
            }
            ArrayList var3 = Lists.newArrayList();
            for (Entity entity : var2) {
                var3.add(entity.getScoreboardName());
            }
            return var3;
        }
    }

    public static class c
    implements ArgumentSerializer<ArgumentScoreholder> {
        @Override
        public void serializeToNetwork(ArgumentScoreholder var0, PacketDataSerializer var1) {
            int var2 = 0;
            if (var0.multiple) {
                var2 = (byte)(var2 | 1);
            }
            var1.writeByte(var2);
        }

        @Override
        public ArgumentScoreholder deserializeFromNetwork(PacketDataSerializer var0) {
            byte var1 = var0.readByte();
            boolean var2 = (var1 & 1) != 0;
            return new ArgumentScoreholder(var2);
        }

        @Override
        public void serializeToJson(ArgumentScoreholder var0, JsonObject var1) {
            var1.addProperty("amount", var0.multiple ? "multiple" : "single");
        }

        @Override
        public /* synthetic */ ArgumentType deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }
    }
}

