/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.ScoreboardObjective;

public class ArgumentScoreboardObjective
implements ArgumentType<String> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "*", "012");
    private static final DynamicCommandExceptionType ERROR_OBJECTIVE_NOT_FOUND = new DynamicCommandExceptionType(var0 -> new ChatMessage("arguments.objective.notFound", var0));
    private static final DynamicCommandExceptionType ERROR_OBJECTIVE_READ_ONLY = new DynamicCommandExceptionType(var0 -> new ChatMessage("arguments.objective.readonly", var0));

    public static ArgumentScoreboardObjective objective() {
        return new ArgumentScoreboardObjective();
    }

    public static ScoreboardObjective getObjective(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        String var2 = (String)var0.getArgument(var1, String.class);
        ScoreboardServer var3 = ((CommandListenerWrapper)var0.getSource()).getServer().getScoreboard();
        ScoreboardObjective var4 = var3.getObjective(var2);
        if (var4 == null) {
            throw ERROR_OBJECTIVE_NOT_FOUND.create((Object)var2);
        }
        return var4;
    }

    public static ScoreboardObjective getWritableObjective(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        ScoreboardObjective var2 = ArgumentScoreboardObjective.getObjective(var0, var1);
        if (var2.getCriteria().isReadOnly()) {
            throw ERROR_OBJECTIVE_READ_ONLY.create((Object)var2.getName());
        }
        return var2;
    }

    public String parse(StringReader var0) throws CommandSyntaxException {
        return var0.readUnquotedString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        if (var0.getSource() instanceof CommandListenerWrapper) {
            return ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getServer().getScoreboard().getObjectiveNames(), var1);
        }
        if (var0.getSource() instanceof ICompletionProvider) {
            ICompletionProvider var2 = (ICompletionProvider)var0.getSource();
            return var2.customSuggestion(var0, var1);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

