/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;

public class ArgumentEntity
implements ArgumentType<EntitySelector> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_ENTITY = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.toomany"));
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_PLAYER = new SimpleCommandExceptionType((Message)new ChatMessage("argument.player.toomany"));
    public static final SimpleCommandExceptionType ERROR_ONLY_PLAYERS_ALLOWED = new SimpleCommandExceptionType((Message)new ChatMessage("argument.player.entities"));
    public static final SimpleCommandExceptionType NO_ENTITIES_FOUND = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType ERROR_SELECTORS_NOT_ALLOWED = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.selector.not_allowed"));
    private static final byte FLAG_SINGLE = 1;
    private static final byte FLAG_PLAYERS_ONLY = 2;
    final boolean single;
    final boolean playersOnly;

    protected ArgumentEntity(boolean var0, boolean var1) {
        this.single = var0;
        this.playersOnly = var1;
    }

    public static ArgumentEntity entity() {
        return new ArgumentEntity(true, false);
    }

    public static Entity getEntity(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ((EntitySelector)var0.getArgument(var1, EntitySelector.class)).findSingleEntity((CommandListenerWrapper)var0.getSource());
    }

    public static ArgumentEntity entities() {
        return new ArgumentEntity(false, false);
    }

    public static Collection<? extends Entity> getEntities(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        Collection<? extends Entity> var2 = ArgumentEntity.getOptionalEntities(var0, var1);
        if (var2.isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return var2;
    }

    public static Collection<? extends Entity> getOptionalEntities(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ((EntitySelector)var0.getArgument(var1, EntitySelector.class)).findEntities((CommandListenerWrapper)var0.getSource());
    }

    public static Collection<EntityPlayer> getOptionalPlayers(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ((EntitySelector)var0.getArgument(var1, EntitySelector.class)).findPlayers((CommandListenerWrapper)var0.getSource());
    }

    public static ArgumentEntity player() {
        return new ArgumentEntity(true, true);
    }

    public static EntityPlayer getPlayer(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ((EntitySelector)var0.getArgument(var1, EntitySelector.class)).findSinglePlayer((CommandListenerWrapper)var0.getSource());
    }

    public static ArgumentEntity players() {
        return new ArgumentEntity(false, true);
    }

    public static Collection<EntityPlayer> getPlayers(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        List<EntityPlayer> var2 = ((EntitySelector)var0.getArgument(var1, EntitySelector.class)).findPlayers((CommandListenerWrapper)var0.getSource());
        if (var2.isEmpty()) {
            throw NO_PLAYERS_FOUND.create();
        }
        return var2;
    }

    public EntitySelector parse(StringReader var0) throws CommandSyntaxException {
        boolean var1 = false;
        ArgumentParserSelector var2 = new ArgumentParserSelector(var0);
        EntitySelector var3 = var2.parse();
        if (var3.getMaxResults() > 1 && this.single) {
            if (this.playersOnly) {
                var0.setCursor(0);
                throw ERROR_NOT_SINGLE_PLAYER.createWithContext((ImmutableStringReader)var0);
            }
            var0.setCursor(0);
            throw ERROR_NOT_SINGLE_ENTITY.createWithContext((ImmutableStringReader)var0);
        }
        if (var3.includesEntities() && this.playersOnly && !var3.isSelfSelector()) {
            var0.setCursor(0);
            throw ERROR_ONLY_PLAYERS_ALLOWED.createWithContext((ImmutableStringReader)var0);
        }
        return var3;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var12) {
        if (var0.getSource() instanceof ICompletionProvider) {
            StringReader var2 = new StringReader(var12.getInput());
            var2.setCursor(var12.getStart());
            ICompletionProvider var3 = (ICompletionProvider)var0.getSource();
            ArgumentParserSelector var4 = new ArgumentParserSelector(var2, var3.hasPermission(2));
            try {
                var4.parse();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return var4.fillSuggestions(var12, var1 -> {
                Collection<String> var2 = var3.getOnlinePlayerNames();
                Collection<String> var3 = this.playersOnly ? var2 : Iterables.concat(var2, var3.getSelectedEntities());
                ICompletionProvider.suggest(var3, var1);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class a
    implements ArgumentSerializer<ArgumentEntity> {
        @Override
        public void serializeToNetwork(ArgumentEntity var0, PacketDataSerializer var1) {
            byte var2 = 0;
            if (var0.single) {
                var2 = (byte)(var2 | 1);
            }
            if (var0.playersOnly) {
                var2 = (byte)(var2 | 2);
            }
            var1.writeByte(var2);
        }

        @Override
        public ArgumentEntity deserializeFromNetwork(PacketDataSerializer var0) {
            byte var1 = var0.readByte();
            return new ArgumentEntity((var1 & 1) != 0, (var1 & 2) != 0);
        }

        @Override
        public void serializeToJson(ArgumentEntity var0, JsonObject var1) {
            var1.addProperty("amount", var0.single ? "single" : "multiple");
            var1.addProperty("type", var0.playersOnly ? "players" : "entities");
        }

        @Override
        public /* synthetic */ ArgumentType deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }
    }
}

