/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;

public class ArgumentChatComponent
implements ArgumentType<IChatBaseComponent> {
    private static final Collection<String> EXAMPLES = Arrays.asList("\"hello world\"", "\"\"", "\"{\"text\":\"hello world\"}", "[\"\"]");
    public static final DynamicCommandExceptionType ERROR_INVALID_JSON = new DynamicCommandExceptionType(var0 -> new ChatMessage("argument.component.invalid", var0));

    private ArgumentChatComponent() {
    }

    public static IChatBaseComponent getComponent(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (IChatBaseComponent)var0.getArgument(var1, IChatBaseComponent.class);
    }

    public static ArgumentChatComponent textComponent() {
        return new ArgumentChatComponent();
    }

    public IChatBaseComponent parse(StringReader var0) throws CommandSyntaxException {
        try {
            IChatMutableComponent var1 = IChatBaseComponent.ChatSerializer.fromJson(var0);
            if (var1 == null) {
                throw ERROR_INVALID_JSON.createWithContext((ImmutableStringReader)var0, (Object)"empty");
            }
            return var1;
        }
        catch (Exception var1) {
            String var2 = var1.getCause() != null ? var1.getCause().getMessage() : var1.getMessage();
            throw ERROR_INVALID_JSON.createWithContext((ImmutableStringReader)var0, (Object)var2);
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

