/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;

public class CriterionConditionDistance {
    public static final CriterionConditionDistance ANY = new CriterionConditionDistance(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY);
    private final CriterionConditionValue.DoubleRange x;
    private final CriterionConditionValue.DoubleRange y;
    private final CriterionConditionValue.DoubleRange z;
    private final CriterionConditionValue.DoubleRange horizontal;
    private final CriterionConditionValue.DoubleRange absolute;

    public CriterionConditionDistance(CriterionConditionValue.DoubleRange var0, CriterionConditionValue.DoubleRange var1, CriterionConditionValue.DoubleRange var2, CriterionConditionValue.DoubleRange var3, CriterionConditionValue.DoubleRange var4) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
        this.horizontal = var3;
        this.absolute = var4;
    }

    public static CriterionConditionDistance horizontal(CriterionConditionValue.DoubleRange var0) {
        return new CriterionConditionDistance(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, var0, CriterionConditionValue.DoubleRange.ANY);
    }

    public static CriterionConditionDistance vertical(CriterionConditionValue.DoubleRange var0) {
        return new CriterionConditionDistance(CriterionConditionValue.DoubleRange.ANY, var0, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY);
    }

    public static CriterionConditionDistance absolute(CriterionConditionValue.DoubleRange var0) {
        return new CriterionConditionDistance(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, var0);
    }

    public boolean matches(double var0, double var2, double var4, double var6, double var8, double var10) {
        float var12 = (float)(var0 - var6);
        float var13 = (float)(var2 - var8);
        float var14 = (float)(var4 - var10);
        if (!(this.x.matches(MathHelper.abs(var12)) && this.y.matches(MathHelper.abs(var13)) && this.z.matches(MathHelper.abs(var14)))) {
            return false;
        }
        if (!this.horizontal.matchesSqr(var12 * var12 + var14 * var14)) {
            return false;
        }
        return this.absolute.matchesSqr(var12 * var12 + var13 * var13 + var14 * var14);
    }

    public static CriterionConditionDistance fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "distance");
        CriterionConditionValue.DoubleRange var2 = CriterionConditionValue.DoubleRange.fromJson(var1.get("x"));
        CriterionConditionValue.DoubleRange var3 = CriterionConditionValue.DoubleRange.fromJson(var1.get("y"));
        CriterionConditionValue.DoubleRange var4 = CriterionConditionValue.DoubleRange.fromJson(var1.get("z"));
        CriterionConditionValue.DoubleRange var5 = CriterionConditionValue.DoubleRange.fromJson(var1.get("horizontal"));
        CriterionConditionValue.DoubleRange var6 = CriterionConditionValue.DoubleRange.fromJson(var1.get("absolute"));
        return new CriterionConditionDistance(var2, var3, var4, var5, var6);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        var0.add("x", this.x.serializeToJson());
        var0.add("y", this.y.serializeToJson());
        var0.add("z", this.z.serializeToJson());
        var0.add("horizontal", this.horizontal.serializeToJson());
        var0.add("absolute", this.absolute.serializeToJson());
        return var0;
    }
}

