/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;

public class CriterionProgress {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    @Nullable
    private Date obtained;

    public boolean isDone() {
        return this.obtained != null;
    }

    public void grant() {
        this.obtained = new Date();
    }

    public void revoke() {
        this.obtained = null;
    }

    @Nullable
    public Date getObtained() {
        return this.obtained;
    }

    public String toString() {
        return "CriterionProgress{obtained=" + (Serializable)(this.obtained == null ? "false" : this.obtained) + "}";
    }

    public void serializeToNetwork(PacketDataSerializer var0) {
        var0.writeBoolean(this.obtained != null);
        if (this.obtained != null) {
            var0.writeDate(this.obtained);
        }
    }

    public JsonElement serializeToJson() {
        if (this.obtained != null) {
            return new JsonPrimitive(DATE_FORMAT.format(this.obtained));
        }
        return JsonNull.INSTANCE;
    }

    public static CriterionProgress fromNetwork(PacketDataSerializer var0) {
        CriterionProgress var1 = new CriterionProgress();
        if (var0.readBoolean()) {
            var1.obtained = var0.readDate();
        }
        return var1;
    }

    public static CriterionProgress fromJson(String var0) {
        CriterionProgress var1 = new CriterionProgress();
        try {
            var1.obtained = DATE_FORMAT.parse(var0);
        }
        catch (ParseException var2) {
            throw new JsonSyntaxException("Invalid datetime: " + var0, (Throwable)var2);
        }
        return var1;
    }
}

