/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.ticks.TickListPriority;

public record NextTickListEntry(T type, BlockPosition pos, long triggerTick, TickListPriority priority, long subTickOrder) {
    public static final Comparator<NextTickListEntry<?>> DRAIN_ORDER = (var0, var1) -> {
        int var2 = Long.compare(var0.triggerTick, var1.triggerTick);
        if (var2 != 0) {
            return var2;
        }
        var2 = var0.priority.compareTo(var1.priority);
        if (var2 != 0) {
            return var2;
        }
        return Long.compare(var0.subTickOrder, var1.subTickOrder);
    };
    public static final Comparator<NextTickListEntry<?>> INTRA_TICK_DRAIN_ORDER = (var0, var1) -> {
        int var2 = var0.priority.compareTo(var1.priority);
        if (var2 != 0) {
            return var2;
        }
        return Long.compare(var0.subTickOrder, var1.subTickOrder);
    };
    public static final Hash.Strategy<NextTickListEntry<?>> UNIQUE_TICK_HASH = new Hash.Strategy<NextTickListEntry<?>>(){

        public int hashCode(NextTickListEntry<?> var0) {
            return 31 * var0.pos().hashCode() + var0.type().hashCode();
        }

        public boolean equals(@Nullable NextTickListEntry<?> var0, @Nullable NextTickListEntry<?> var1) {
            if (var0 == var1) {
                return true;
            }
            if (var0 == null || var1 == null) {
                return false;
            }
            return var0.type() == var1.type() && var0.pos().equals(var1.pos());
        }

        public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
            return this.equals((NextTickListEntry)object, (NextTickListEntry)object2);
        }

        public /* synthetic */ int hashCode(Object object) {
            return this.hashCode((NextTickListEntry)object);
        }
    };

    public NextTickListEntry(T var0, BlockPosition var1, long var2, long var4) {
        this(var0, var1, var2, TickListPriority.NORMAL, var4);
    }

    public NextTickListEntry {
        var1 = var1.immutable();
    }

    public static <T> NextTickListEntry<T> probe(T var0, BlockPosition var1) {
        return new NextTickListEntry(var0, var1, 0L, TickListPriority.NORMAL, 0L);
    }
}

