/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.score;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.JsonRegistry;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;

public class ContextScoreboardNameProvider
implements ScoreboardNameProvider {
    final LootTableInfo.EntityTarget target;

    ContextScoreboardNameProvider(LootTableInfo.EntityTarget var0) {
        this.target = var0;
    }

    public static ScoreboardNameProvider forTarget(LootTableInfo.EntityTarget var0) {
        return new ContextScoreboardNameProvider(var0);
    }

    @Override
    public LootScoreProviderType getType() {
        return ScoreboardNameProviders.CONTEXT;
    }

    @Override
    @Nullable
    public String getScoreboardName(LootTableInfo var0) {
        Entity var1 = var0.getParamOrNull(this.target.getParam());
        return var1 != null ? var1.getScoreboardName() : null;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(this.target.getParam());
    }

    public static class a
    implements JsonRegistry.b<ContextScoreboardNameProvider> {
        @Override
        public JsonElement serialize(ContextScoreboardNameProvider var0, JsonSerializationContext var1) {
            return var1.serialize((Object)var0.target);
        }

        @Override
        public ContextScoreboardNameProvider deserialize(JsonElement var0, JsonDeserializationContext var1) {
            LootTableInfo.EntityTarget var2 = (LootTableInfo.EntityTarget)((Object)var1.deserialize(var0, LootTableInfo.EntityTarget.class));
            return new ContextScoreboardNameProvider(var2);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonElement jsonElement, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonElement, jsonDeserializationContext);
        }
    }

    public static class b
    implements LootSerializer<ContextScoreboardNameProvider> {
        @Override
        public void serialize(JsonObject var0, ContextScoreboardNameProvider var1, JsonSerializationContext var2) {
            var0.addProperty("target", var1.target.name());
        }

        @Override
        public ContextScoreboardNameProvider deserialize(JsonObject var0, JsonDeserializationContext var1) {
            LootTableInfo.EntityTarget var2 = ChatDeserializer.getAsObject(var0, "target", var1, LootTableInfo.EntityTarget.class);
            return new ContextScoreboardNameProvider(var2);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

