/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.authlib.GameProfile;
import java.util.Set;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionFillPlayerHead
extends LootItemFunctionConditional {
    final LootTableInfo.EntityTarget entityTarget;

    public LootItemFunctionFillPlayerHead(LootItemCondition[] var0, LootTableInfo.EntityTarget var1) {
        super(var0);
        this.entityTarget = var1;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.FILL_PLAYER_HEAD;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(this.entityTarget.getParam());
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        Entity var2;
        if (var0.is(Items.PLAYER_HEAD) && (var2 = var1.getParamOrNull(this.entityTarget.getParam())) instanceof EntityHuman) {
            GameProfile var3 = ((EntityHuman)var2).getGameProfile();
            var0.getOrCreateTag().put("SkullOwner", GameProfileSerializer.writeGameProfile(new NBTTagCompound(), var3));
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> fillPlayerHead(LootTableInfo.EntityTarget var0) {
        return LootItemFunctionFillPlayerHead.simpleBuilder(var1 -> new LootItemFunctionFillPlayerHead((LootItemCondition[])var1, var0));
    }

    public static class a
    extends LootItemFunctionConditional.c<LootItemFunctionFillPlayerHead> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionFillPlayerHead var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.add("entity", var2.serialize((Object)var1.entityTarget));
        }

        @Override
        public LootItemFunctionFillPlayerHead deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            LootTableInfo.EntityTarget var3 = ChatDeserializer.getAsObject(var0, "entity", var1, LootTableInfo.EntityTarget.class);
            return new LootItemFunctionFillPlayerHead(var2, var3);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

